/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.manager;

import com.atlassian.jira.plugins.importer.redmine.CustomFieldDefinition;
import com.atlassian.jira.plugins.importer.redmine.UserOrGroup;
import com.atlassian.jira.plugins.importer.redmine.manager.ComplementRedmineManager;
import com.atlassian.jira.plugins.importer.redmine.manager.ComplementRedmineManagerImpl;
import com.atlassian.jira.plugins.importer.redmine.manager.JiraRedmineManager;
import com.atlassian.jira.util.AttachmentUtils;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.taskadapter.redmineapi.Include;
import com.taskadapter.redmineapi.NotAuthorizedException;
import com.taskadapter.redmineapi.NotFoundException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedJiraRedmineManager
implements JiraRedmineManager {
    private final Logger log = LoggerFactory.getLogger(ComplementRedmineManagerImpl.class);
    private static final Comparator<Issue> ISSUE_BY_ID_COMPARATOR = new Comparator<Issue>(){

        @Override
        public int compare(Issue o1, Issue o2) {
            return o1.getId() - o2.getId();
        }
    };
    private final CacheLoader<Integer, Group> GROUP_CACHE_LOADER = new CacheLoader<Integer, Group>(){

        public Group load(Integer key) throws Exception {
            return CachedJiraRedmineManager.this.manager.getUserManager().getGroupById(key.intValue());
        }
    };
    private final CacheLoader<Integer, Collection<User>> USERS_IN_GROUP_CACHE_LOADER = new CacheLoader<Integer, Collection<User>>(){

        public Collection<User> load(Integer key) throws Exception {
            Iterable<Integer> userIdsForGroup;
            try {
                userIdsForGroup = CachedJiraRedmineManager.this.complementManager.getUserIdsForGroup(key);
            }
            catch (RedmineException e) {
                return ImmutableList.of();
            }
            Iterable users = Iterables.transform(userIdsForGroup, (Function)new Function<Integer, User>(){

                public User apply(Integer input) {
                    try {
                        return CachedJiraRedmineManager.this.getUserById(input);
                    }
                    catch (RedmineException redmineException) {
                        return null;
                    }
                }
            });
            Iterable validUsers = Iterables.filter((Iterable)users, (Predicate)Predicates.notNull());
            return ImmutableList.copyOf((Iterable)validUsers);
        }
    };
    private final CacheLoader<String, List<Issue>> ISSUE_LOADER = new CacheLoader<String, List<Issue>>(){

        public List<Issue> load(String key) throws Exception {
            try {
                List issues = CachedJiraRedmineManager.this.manager.getIssueManager().getIssues((Map)ImmutableMap.of((Object)"include", (Object)"relations", (Object)"project_id", (Object)key, (Object)"subproject_id", (Object)"!*", (Object)"status_id", (Object)"*"));
                Collections.sort(issues, ISSUE_BY_ID_COMPARATOR);
                return issues;
            }
            catch (NotAuthorizedException e) {
                CachedJiraRedmineManager.this.log.warn("No issues for Redmine project " + key + " , probably issue tracking module is disabled.");
                CachedJiraRedmineManager.this.log.debug("Exception for downloading issues from Redmine Project: " + key, (Throwable)e);
                return ImmutableList.of();
            }
        }
    };
    private final RedmineManager manager;
    private final ComplementRedmineManager complementManager;
    private List<Project> projectsCache;
    private final Map<String, List<Version>> versionsCache = Maps.newHashMap();
    private final Map<String, List<IssueCategory>> categoriesCache = Maps.newHashMap();
    private final Map<String, Issue> singleIssuesCache = Maps.newHashMap();
    private final Map<Integer, List<TimeEntry>> timeEntriesCache = Maps.newHashMap();
    private List<IssueStatus> issueStatusesCache;
    private final Map<Integer, User> usersCache = Maps.newHashMap();
    private final Map<Integer, Group> groupCache = Maps.newHashMap();
    private final Map<Integer, Collection<User>> usersInGroupCache = Maps.newHashMap();
    private final Map<String, List<Issue>> issuesCache = Maps.newHashMap();
    private List<Tracker> trackersCache;
    private List<User> allUsersCache;
    private Iterable<CustomFieldDefinition> allCustomFields;

    public CachedJiraRedmineManager(RedmineManager manager, ComplementRedmineManager complementManager) {
        this.manager = manager;
        this.complementManager = complementManager;
    }

    @Override
    public List<Project> getProjects() throws RedmineException {
        if (this.projectsCache == null) {
            this.projectsCache = this.disambiguateProjectNames(this.manager.getProjectManager().getProjects());
        }
        return this.projectsCache;
    }

    private List<Project> disambiguateProjectNames(List<Project> projects) {
        final HashSet projectNames = Sets.newHashSet();
        return Lists.newArrayList((Iterable)Iterables.transform(projects, (Function)new Function<Project, Project>(){

            public Project apply(Project project) {
                StringBuilder projectName = new StringBuilder(project.getName());
                while (projectNames.contains(projectName.toString())) {
                    projectName.append('_');
                }
                projectNames.add(projectName.toString());
                project.setName(projectName.toString());
                return project;
            }
        }));
    }

    @Override
    public List<Version> getVersions(String projectId) throws RedmineException {
        if (!this.versionsCache.containsKey(projectId)) {
            Integer projectIdInteger;
            try {
                projectIdInteger = Integer.valueOf(projectId);
            }
            catch (NumberFormatException e) {
                return Collections.emptyList();
            }
            try {
                this.versionsCache.put(projectId, this.manager.getProjectManager().getVersions(projectIdInteger.intValue()));
            }
            catch (NotAuthorizedException e) {
                this.log.warn("Cannot get versions for Redmine project " + projectId + ". Probably issue tracking module is disabled");
                this.log.debug("Redmine Versions exception for Project: " + projectId, (Throwable)e);
                this.versionsCache.put(projectId, (List<Version>)ImmutableList.of());
                return ImmutableList.of();
            }
        }
        return this.versionsCache.get(projectId);
    }

    @Override
    public List<IssueCategory> getCategories(String projectId) throws RedmineException {
        if (!this.categoriesCache.containsKey(projectId)) {
            Integer projectIdInteger;
            try {
                projectIdInteger = Integer.valueOf(projectId);
            }
            catch (NumberFormatException e) {
                return Collections.emptyList();
            }
            try {
                this.categoriesCache.put(projectId, this.manager.getIssueManager().getCategories(projectIdInteger.intValue()));
            }
            catch (NotAuthorizedException e) {
                this.log.warn("Cannot get categories for Redmine project " + projectId + ". Probably issue tracking module is disabled");
                this.log.debug("Redmine Categories exception for Project: " + projectId, (Throwable)e);
                this.categoriesCache.put(projectId, (List<IssueCategory>)ImmutableList.of());
                return ImmutableList.of();
            }
        }
        return this.categoriesCache.get(projectId);
    }

    @Override
    public JiraRedmineManager.LoginResult login() throws RedmineException {
        try {
            List<User> users = this.getUsers();
            if (users.size() > 0) {
                return JiraRedmineManager.LoginResult.ok();
            }
            this.log.warn("Redmine Manager returned 0 users!");
        }
        catch (Exception e) {
            this.log.warn("Cannot login to redmine (Execute /users.json)", (Throwable)e);
        }
        return JiraRedmineManager.LoginResult.error(this.complementManager.getLoginErrorMessage());
    }

    @Override
    public void shutdown() {
        this.manager.shutdown();
        this.complementManager.shutdown();
        this.projectsCache = null;
        this.versionsCache.clear();
        this.categoriesCache.clear();
        this.singleIssuesCache.clear();
        this.timeEntriesCache.clear();
        this.issuesCache.clear();
        this.issueStatusesCache = null;
        this.usersCache.clear();
        this.groupCache.clear();
        this.usersInGroupCache.clear();
        this.trackersCache = null;
        this.allUsersCache = null;
        this.allCustomFields = null;
    }

    @Override
    public List<IssueStatus> getStatuses() throws RedmineException {
        if (this.issueStatusesCache == null) {
            this.issueStatusesCache = this.manager.getIssueManager().getStatuses();
        }
        return this.issueStatusesCache;
    }

    @Override
    public List<Issue> getIssues(String projectId) throws RedmineException {
        if (!this.issuesCache.containsKey(projectId)) {
            try {
                this.issuesCache.put(projectId, (List<Issue>)this.ISSUE_LOADER.load((Object)projectId));
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf((Throwable)e.getCause(), RedmineException.class);
                throw new IllegalStateException(e);
            }
        }
        return this.issuesCache.get(projectId);
    }

    @Override
    public User getUserById(Integer userId) throws RedmineException {
        if (!this.usersCache.containsKey(userId)) {
            this.usersCache.put(userId, this.manager.getUserManager().getUserById(userId));
        }
        return this.usersCache.get(userId);
    }

    @Override
    public List<Tracker> getTrackers() throws RedmineException {
        if (this.trackersCache == null) {
            this.trackersCache = this.manager.getIssueManager().getTrackers();
        }
        return this.trackersCache;
    }

    @Override
    public List<User> getUsers() throws RedmineException {
        if (this.allUsersCache == null) {
            this.allUsersCache = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.manager.getUserManager().getUsers(), (Predicate)new Predicate<User>(){

                public boolean apply(@Nullable User input) {
                    return input != null && StringUtils.isNotBlank((CharSequence)input.getLogin());
                }
            }));
        }
        return this.allUsersCache;
    }

    @Override
    public Issue getIssueById(String issueId) throws RedmineException {
        if (!this.singleIssuesCache.containsKey(issueId)) {
            Integer issueIdInteger;
            try {
                issueIdInteger = Integer.valueOf(issueId);
            }
            catch (NumberFormatException e) {
                return null;
            }
            this.singleIssuesCache.put(issueId, this.manager.getIssueManager().getIssueById(issueIdInteger, Include.values()));
        }
        return this.singleIssuesCache.get(issueId);
    }

    @Override
    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws RedmineException {
        if (!this.timeEntriesCache.containsKey(issueId)) {
            List timeEntriesForIssue;
            try {
                timeEntriesForIssue = this.manager.getIssueManager().getTimeEntriesForIssue(issueId);
            }
            catch (NotAuthorizedException e) {
                return Collections.emptyList();
            }
            this.timeEntriesCache.put(issueId, timeEntriesForIssue);
        }
        return this.timeEntriesCache.get(issueId);
    }

    @Override
    public Optional<Group> getGroupById(Integer groupId) throws RedmineException {
        if (!this.groupCache.containsKey(groupId)) {
            try {
                this.groupCache.put(groupId, (Group)this.GROUP_CACHE_LOADER.load((Object)groupId));
            }
            catch (Exception e) {
                this.groupCache.put(groupId, null);
            }
        }
        return Optional.fromNullable((Object)this.groupCache.get(groupId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getAttachmentContent(Attachment input) throws RedmineException, IOException {
        File file = this.getTempFile();
        OutputStream output = null;
        try {
            output = this.getOutputStream(file);
            this.downloadAttachment(input, output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return file;
    }

    private void downloadAttachment(Attachment attachment, OutputStream os) throws RedmineException {
        try {
            this.manager.getAttachmentManager().downloadAttachmentContent(attachment, os);
        }
        catch (NotFoundException e) {
            String contentURL = attachment.getContentURL();
            String attachmentBaseUrl = contentURL.substring(0, contentURL.lastIndexOf("/"));
            attachment.setContentURL(attachmentBaseUrl);
            this.manager.getAttachmentManager().downloadAttachmentContent(attachment, os);
        }
    }

    @Override
    public Collection<User> getUsersForGroup(Integer groupId) throws RedmineException {
        if (!this.usersInGroupCache.containsKey(groupId)) {
            try {
                this.usersInGroupCache.put(groupId, (Collection<User>)this.USERS_IN_GROUP_CACHE_LOADER.load((Object)groupId));
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e.getCause(), RedmineException.class);
                throw new IllegalStateException(e);
            }
        }
        return this.usersInGroupCache.get(groupId);
    }

    @Override
    public Optional<UserOrGroup> getUserOrGroup(Integer id) throws RedmineException {
        if (this.usersCache.containsKey(id)) {
            return Optional.of((Object)UserOrGroup.createForUser(this.usersCache.get(id)));
        }
        try {
            return Optional.of((Object)UserOrGroup.createForUser(this.getUserById(id)));
        }
        catch (NotFoundException e) {
            Optional<Group> group = this.getGroupById(id);
            if (group.isPresent()) {
                return Optional.of((Object)UserOrGroup.createForGroup((Group)group.get()));
            }
            return Optional.absent();
        }
    }

    @Override
    public Iterable<CustomFieldDefinition> getCustomFieldDefinitions() throws RedmineException {
        if (this.allCustomFields == null) {
            this.allCustomFields = this.complementManager.getCustomFieldDefinitions();
        }
        return this.allCustomFields;
    }

    private File getTempDir() {
        return AttachmentUtils.getTemporaryAttachmentDirectory();
    }

    OutputStream getOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    File getTempFile() throws IOException {
        File file = File.createTempFile("attachmentTransformer-", ".tmp", this.getTempDir());
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir((File)file.getParentFile());
        }
        return file;
    }
}

