/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.redmine.CustomFieldDefinition;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.atlassian.jira.plugins.importer.redmine.RedmineRemoteException;
import com.atlassian.jira.plugins.importer.redmine.UserOrGroup;
import com.atlassian.jira.plugins.importer.redmine.manager.JiraRedmineManager;
import com.atlassian.jira.plugins.importer.redmine.manager.JiraRedmineManagerFactory;
import com.atlassian.jira.plugins.importer.redmine.transformer.AttachmentTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.ComponentTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.CustomFieldTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.IssueToRelationsTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.IssueTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.Redmine24CustomFieldTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.StatusTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.TrackerTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.UserTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.VersionTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.WorklogTransformer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.taskadapter.redmineapi.RedmineConfigurationException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Journal;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;

public class RedmineClient {
    private JiraRedmineManager jiraRedmineManager;
    private final RedmineConfigBean redmineConfigBean;
    private final JiraRedmineManagerFactory managerFactory;
    private final boolean timeTrackingEnabled;
    private Collection<ExternalCustomField> customFields;
    private Function<CustomField, ExternalCustomFieldValue> customFieldValueTransformer;

    public RedmineClient(JiraRedmineManagerFactory managerFactory, RedmineConfigBean redmineConfigBean, boolean timeTrackingEnabled) {
        this.managerFactory = managerFactory;
        this.redmineConfigBean = redmineConfigBean;
        this.timeTrackingEnabled = timeTrackingEnabled;
    }

    public void login() {
        try {
            if (this.jiraRedmineManager == null) {
                JiraRedmineManager redmineManager = this.managerFactory.create();
                JiraRedmineManager.LoginResult loginResult = redmineManager.login();
                if (!loginResult.isValid()) {
                    String msg = Joiner.on((String)", ").join((Iterable)loginResult.getErrorCollection().getErrorMessages());
                    throw new RedmineRemoteException(msg);
                }
                this.jiraRedmineManager = redmineManager;
            }
        }
        catch (RedmineException e) {
            throw new RedmineRemoteException(e.getMessage(), e);
        }
        catch (RedmineInternalError e) {
            throw new RedmineRemoteException(e.getMessage(), e);
        }
        catch (RedmineConfigurationException e) {
            throw new RedmineRemoteException(e.getMessage(), e);
        }
    }

    public void logout() {
        if (this.jiraRedmineManager != null) {
            JiraRedmineManager localCopy = this.jiraRedmineManager;
            this.jiraRedmineManager = null;
            localCopy.shutdown();
        }
    }

    public Collection<String> getAllExternalProjectNames() throws RedmineRemoteException {
        return this.getValues(new Function<Project, String>(){

            public String apply(Project o) {
                return o.getName();
            }
        }, new ValueAccessor<Collection<Project>>(){

            @Override
            protected Collection<Project> getValue() throws Exception {
                return RedmineClient.this.jiraRedmineManager.getProjects();
            }
        });
    }

    public Collection<ExternalProject> getAllProjects(ImportLogger log) throws RedmineRemoteException {
        return this.getValues(new ProjectTransformer(this.redmineConfigBean), new ValueAccessor<Collection<Project>>(log){

            @Override
            public Collection<Project> getValue() throws RedmineException {
                return RedmineClient.this.jiraRedmineManager.getProjects();
            }
        });
    }

    public Collection<ExternalVersion> getVersions(final String projectId, ImportLogger log) {
        return this.getValues(new VersionTransformer(), new ValueAccessor<Collection<Version>>(log){

            @Override
            public Collection<Version> getValue() throws RedmineException {
                return RedmineClient.this.jiraRedmineManager.getVersions(projectId);
            }
        });
    }

    public Collection<ExternalComponent> getComponents(final String projectId, ImportLogger log) {
        return this.getValues(new ComponentTransformer(this), new ValueAccessor<Collection<IssueCategory>>(log){

            @Override
            public Collection<IssueCategory> getValue() throws RedmineException {
                return RedmineClient.this.jiraRedmineManager.getCategories(projectId);
            }
        });
    }

    public Collection<ExternalIssue> getIssues(final String projectId, final ImportLogger log) {
        return this.getValues(new IssueTransformer(this.redmineConfigBean, this.timeTrackingEnabled, log, this.customFieldValueTransformer), new ValueAccessor<Collection<Issue>>(log){

            @Override
            public Collection<Issue> getValue() throws RedmineException {
                return Collections2.transform((Collection)RedmineClient.this.getIssuesForProject(projectId), (Function)new Function<Issue, Issue>(){

                    public Issue apply(Issue issue) {
                        try {
                            return RedmineClient.this.jiraRedmineManager.getIssueById(String.valueOf(issue.getId()));
                        }
                        catch (RedmineException e) {
                            throw RedmineClient.this.translateException((Exception)((Object)e), log, new String[]{"Cannot fetch issue id=" + issue.getId()});
                        }
                    }
                });
            }
        });
    }

    public Collection<String> getAllUserLoginsForGroup(final Integer groupId) {
        Function<User, String> userToLogin = new Function<User, String>(){

            public String apply(User input) {
                return input.getLogin();
            }
        };
        return this.getValues(userToLogin, new ValueAccessor<Collection<User>>(){

            @Override
            protected Collection<User> getValue() throws Exception {
                return RedmineClient.this.jiraRedmineManager.getUsersForGroup(groupId);
            }
        });
    }

    public Collection<ExternalUser> getAllUsers(ImportLogger log) {
        return this.getValues(new UserTransformer(), new ValueAccessor<Collection<User>>(log){

            @Override
            public Collection<User> getValue() throws RedmineException {
                return RedmineClient.this.jiraRedmineManager.getUsers();
            }
        });
    }

    public Collection<String> getStatuses() {
        return this.getValues(new StatusTransformer(), new ValueAccessor<Collection<IssueStatus>>(){

            @Override
            public List<IssueStatus> getValue() throws RedmineException {
                return RedmineClient.this.jiraRedmineManager.getStatuses();
            }
        });
    }

    public Collection<String> getPriorities() {
        return this.getDistinctValuesForProjects(this.getSelectedProjects(), null, new Function<Issue, Collection<String>>(){

            public Collection<String> apply(Issue input) {
                return Lists.newArrayList((Object[])new String[]{input.getPriorityText()});
            }
        });
    }

    public Collection<String> getTrackers() {
        return this.getValues(new TrackerTransformer(), new ValueAccessor<Collection<Tracker>>(){

            @Override
            public Collection<Tracker> getValue() throws RedmineException {
                return RedmineClient.this.jiraRedmineManager.getTrackers();
            }
        });
    }

    public Set<String> getLinkNames() {
        return this.getDistinctValuesForProjects(this.getSelectedProjects(), null, new Function<Issue, Collection<String>>(){

            public Collection<String> apply(Issue input) {
                ArrayList types = Lists.newArrayList();
                for (IssueRelation issueRelation : input.getRelations()) {
                    types.add(issueRelation.getType());
                }
                return types;
            }
        });
    }

    public Set<String> getUserIdsForProjects(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getDistinctValuesForProjects(projects, importLogger, new Function<Issue, Collection<String>>(){

            public Collection<String> apply(final Issue issue) {
                HashSet users = Sets.newHashSet();
                if (issue.getAssignee() != null) {
                    users.add(issue.getAssignee().getId().toString());
                }
                if (issue.getAuthor() != null) {
                    users.add(issue.getAuthor().getId().toString());
                }
                for (Journal journal : issue.getJournals()) {
                    users.add(journal.getUser().getId().toString());
                }
                for (Attachment attachment : issue.getAttachments()) {
                    users.add(attachment.getAuthor().getId().toString());
                }
                users.addAll(RedmineClient.this.getValues((Function)new Function<TimeEntry, String>(){

                    public String apply(TimeEntry input) {
                        return input.getUserId() != null ? input.getUserId().toString() : "";
                    }
                }, new ValueAccessor<Collection<TimeEntry>>(){

                    @Override
                    protected Collection<TimeEntry> getValue() throws Exception {
                        return RedmineClient.this.jiraRedmineManager.getTimeEntriesForIssue(issue.getId());
                    }
                }));
                users.remove("");
                return users;
            }
        });
    }

    public Collection<ExternalLink> getLinks(Collection<ExternalProject> projects, ImportLogger log) {
        return this.getDistinctValuesForProjects(projects, log, new IssueToRelationsTransformer(this.redmineConfigBean));
    }

    public synchronized Collection<ExternalCustomField> getCustomFields() {
        if (this.customFields != null) {
            return this.customFields;
        }
        this.login();
        if (this.getCustomFieldsFromRedmine24()) {
            return this.customFields;
        }
        this.customFields = this.getCustomFieldsFromRedminePrior24();
        this.customFieldValueTransformer = new CustomFieldTransformer.CustomFiledValueTransformer(this.redmineConfigBean);
        return this.customFields;
    }

    private Collection<ExternalCustomField> getCustomFieldsFromRedminePrior24() {
        HashSet fields = Sets.newHashSet();
        try {
            for (ExternalProject project : this.getSelectedProjects()) {
                for (Issue issue : this.jiraRedmineManager.getIssues(project.getId())) {
                    if (issue.getCustomFields() == null) continue;
                    fields.addAll(Lists.transform((List)Lists.newArrayList((Iterable)issue.getCustomFields()), (Function)new CustomFieldTransformer.CustomFieldDefinitionTransformer()));
                }
            }
        }
        catch (RedmineException e) {
            throw new RedmineRemoteException("Cannot retrieve custom fields", e);
        }
        return fields;
    }

    private boolean getCustomFieldsFromRedmine24() {
        try {
            Iterable<CustomFieldDefinition> customFields = this.jiraRedmineManager.getCustomFieldDefinitions();
            Redmine24CustomFieldTransformer transformer = new Redmine24CustomFieldTransformer(this.redmineConfigBean, this);
            Iterable fields = Iterables.transform(customFields, transformer.getDefinitionTransformer());
            this.customFieldValueTransformer = transformer.getValueTransformer();
            this.customFields = ImmutableList.copyOf((Iterable)fields);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Collection<ExternalProject> getSelectedProjects() throws RedmineRemoteException {
        try {
            Iterable selectedProjects = Iterables.filter(this.jiraRedmineManager.getProjects(), (Predicate)new Predicate<Project>(){

                public boolean apply(Project input) {
                    return RedmineClient.this.redmineConfigBean.isProjectSelected(input.getName());
                }
            });
            final ImmutableSet selectedProjectIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)selectedProjects, (Function)new Function<Project, String>(){

                public String apply(Project input) {
                    return input.getId().toString();
                }
            }));
            Iterable externalProjects = Iterables.filter(this.getAllProjects(null), (Predicate)new Predicate<ExternalProject>(){

                public boolean apply(ExternalProject input) {
                    return selectedProjectIds.contains((Object)input.getId());
                }
            });
            return ImmutableSet.copyOf((Iterable)externalProjects);
        }
        catch (RedmineException e) {
            throw new RedmineRemoteException("Cannot get selected Redmine Projects", e);
        }
    }

    public Optional<UserOrGroup> getUserOrGroup(final @Nullable User user) {
        if (user == null || user.getId() == null) {
            return Optional.absent();
        }
        return (Optional)new ValueAccessor<Optional<UserOrGroup>>(){

            @Override
            protected Optional<UserOrGroup> getValue() throws Exception {
                return RedmineClient.this.jiraRedmineManager.getUserOrGroup(user.getId());
            }
        }.get();
    }

    public String getUserName(@Nullable Integer userId) {
        this.login();
        if (userId == null) {
            return null;
        }
        try {
            User userById = this.jiraRedmineManager.getUserById(userId);
            return userById == null ? null : userById.getLogin();
        }
        catch (RedmineException e) {
            throw this.translateException((Exception)((Object)e), null, new String[0]);
        }
    }

    public String getUserName(@Nullable User user) {
        return user == null ? null : this.getUserName(user.getId());
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(final String externalId, ImportLogger logger) {
        Iterable attachments = Iterables.transform((Iterable)((Iterable)new ValueAccessor<Collection<Attachment>>(){

            @Override
            public Collection<Attachment> getValue() throws RedmineException {
                Issue issue = RedmineClient.this.jiraRedmineManager.getIssueById(externalId);
                if (CollectionUtils.isEmpty((Collection)issue.getAttachments())) {
                    return Collections.emptyList();
                }
                return issue.getAttachments();
            }
        }.get()), (Function)new AttachmentTransformer(this, logger));
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)attachments, (Predicate)Predicates.notNull()));
    }

    public File getAttachmentContent(Attachment attachment, ImportLogger logger) {
        try {
            return this.jiraRedmineManager.getAttachmentContent((Attachment)Preconditions.checkNotNull((Object)attachment));
        }
        catch (Exception e) {
            throw new RedmineRemoteException("Error while downloading attachment", e);
        }
    }

    public Collection<ExternalWorklog> getWorklogForIssue(final Integer issueId, ImportLogger logger) {
        return this.getValues(new WorklogTransformer(this), new ValueAccessor<Collection<TimeEntry>>(logger){

            @Override
            protected Collection<TimeEntry> getValue() throws Exception {
                List<TimeEntry> timeEntriesForIssue = RedmineClient.this.jiraRedmineManager.getTimeEntriesForIssue(issueId);
                return ImmutableList.copyOf((Iterable)Iterables.filter(timeEntriesForIssue, (Predicate)new Predicate<TimeEntry>(){

                    public boolean apply(TimeEntry input) {
                        return issueId.equals(input.getIssueId());
                    }
                }));
            }
        });
    }

    private <F, T> Collection<T> getValues(Function<F, T> transformer, ValueAccessor<? extends Collection<F>> valueAccessor) {
        return Collections2.transform(valueAccessor.get(), transformer);
    }

    private RedmineRemoteException translateException(Exception e, ImportLogger logger, String ... msg) {
        String message;
        String string = message = ArrayUtils.isEmpty((Object[])msg) ? "Unexpected exception while importing from redmine" : Joiner.on((char)',').join((Object[])msg);
        if (logger != null) {
            logger.fail((Throwable)e, message, new Object[0]);
        }
        return new RedmineRemoteException(message, e);
    }

    private <T> Set<T> getDistinctValuesForProjects(Collection<ExternalProject> projects, ImportLogger importLogger, Function<Issue, Collection<T>> accessor) {
        this.login();
        try {
            HashSet distinctValues = Sets.newHashSet();
            for (ExternalProject project : projects) {
                for (Issue issue : this.getIssuesForProject(project.getId())) {
                    distinctValues.addAll((Collection)accessor.apply((Object)issue));
                }
            }
            return distinctValues;
        }
        catch (RedmineException e) {
            throw this.translateException((Exception)((Object)e), importLogger, "Cannot retrieve values from issues ");
        }
    }

    private Collection<Issue> getIssuesForProject(String projectId) throws RedmineException {
        return this.jiraRedmineManager.getIssues(projectId);
    }

    private abstract class ValueAccessor<F>
    implements Supplier<F> {
        private final ImportLogger log;

        public ValueAccessor(ImportLogger log) {
            this.log = log;
        }

        protected ValueAccessor() {
            this.log = null;
        }

        public final F get() {
            try {
                RedmineClient.this.login();
                return this.getValue();
            }
            catch (Exception e) {
                throw RedmineClient.this.translateException(e, this.log, new String[]{"Irrecoverable error while importing data from redmine"});
            }
        }

        protected abstract F getValue() throws Exception;
    }
}

