/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.functions;

import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class HelpUrlFunction
implements SoyClientFunction,
SoyServerFunction<String> {
    private static final Set<Integer> ARGS_SIZES = Collections.singleton(1);
    private static final Pattern SOY_STRING_PATTERN = Pattern.compile("^'(.*)'$");
    private final HelpPathResolver helpPathResolver;

    public HelpUrlFunction(HelpPathResolver helpPathResolver) {
        this.helpPathResolver = (HelpPathResolver)Preconditions.checkNotNull((Object)helpPathResolver);
    }

    public String getName() {
        return "helpUrl";
    }

    public Set<Integer> validArgSizes() {
        return ARGS_SIZES;
    }

    public JsExpression generate(JsExpression ... args) {
        Matcher matcher = SOY_STRING_PATTERN.matcher(args[0].getText());
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"The help key name should be a string literal");
        String helpUrl = this.getHelpUrl(matcher.group(1));
        return new JsExpression('\"' + StringEscapeUtils.escapeJavaScript((String)helpUrl) + '\"');
    }

    public String apply(Object ... args) {
        String helpKey = (String)args[0];
        return this.getHelpUrl(helpKey);
    }

    private String getHelpUrl(String helpKey) {
        return this.helpPathResolver.getHelpPath(helpKey).getUrl();
    }
}

