/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.gemini.blueprint.service.exporter.OsgiServiceRegistrationListener;
import org.eclipse.gemini.blueprint.service.exporter.support.DefaultInterfaceDetector;
import org.eclipse.gemini.blueprint.service.exporter.support.ExportContextClassLoaderEnum;
import org.eclipse.gemini.blueprint.service.exporter.support.InterfaceDetector;
import org.eclipse.gemini.blueprint.service.exporter.support.OsgiServiceFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ExportedSeviceManager {
    private final Hashtable<Integer, OsgiServiceFactoryBean> exporters = new Hashtable();

    public ServiceRegistration registerService(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, Class<?> ... interfaces) throws Exception {
        OsgiServiceFactoryBean osgiExporter = this.createExporter(bundleContext, bean, beanName, serviceProps, interfaces);
        int hashCode = System.identityHashCode(bean);
        this.exporters.put(hashCode, osgiExporter);
        return osgiExporter.getObject();
    }

    public boolean hasService(Object bean) {
        int hashCode = System.identityHashCode(bean);
        return this.exporters.containsKey(hashCode);
    }

    public void unregisterService(BundleContext bundleContext, Object bean) {
        int hashCode = System.identityHashCode(bean);
        OsgiServiceFactoryBean exporter = this.exporters.get(hashCode);
        if (null != exporter) {
            exporter.destroy();
            this.exporters.remove(hashCode);
        }
    }

    private OsgiServiceFactoryBean createExporter(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, Class<?>[] interfaces) throws Exception {
        serviceProps.put("org.eclipse.gemini.blueprint.bean.name", beanName);
        OsgiServiceFactoryBean exporter = new OsgiServiceFactoryBean();
        exporter.setInterfaceDetector((InterfaceDetector)DefaultInterfaceDetector.DISABLED);
        exporter.setBeanClassLoader(bean.getClass().getClassLoader());
        exporter.setBeanName(beanName);
        exporter.setBundleContext(bundleContext);
        exporter.setExportContextClassLoader(ExportContextClassLoaderEnum.UNMANAGED);
        exporter.setInterfaces((Class[])interfaces);
        exporter.setServiceProperties(serviceProps);
        exporter.setTarget(bean);
        exporter.setListeners(new OsgiServiceRegistrationListener[0]);
        exporter.afterPropertiesSet();
        return exporter;
    }
}

