/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.wikieditor;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;

public class WikiEditorHelpDataProvider
implements WebResourceDataProvider {
    private final ApplicationProperties applicationProperties;
    private final HelpUrls helpUrls;

    public WikiEditorHelpDataProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport HelpUrls helpUrls) {
        this.applicationProperties = applicationProperties;
        this.helpUrls = helpUrls;
    }

    private JSONObject getJsonData() throws JSONException {
        JSONObject values = new JSONObject();
        boolean shouldShowHelp = this.showHelp();
        values.put("showHelp", shouldShowHelp);
        if (shouldShowHelp) {
            HelpUrl editorDocumentation = this.helpUrls.getUrl("editor.documentation");
            values.append("editorDocumentationUrl", (Object)editorDocumentation.getUrl());
            values.append("editorDocumentationTitle", (Object)editorDocumentation.getTitle());
        }
        return values;
    }

    private boolean showHelp() {
        return this.applicationProperties.getOption("jira.rte.enabled");
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.getJsonData().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }
}

