/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.web;

import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterClient;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterConfigBean;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloApiException;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

@WebSudoRequired
public class TrelloProjectSelectionPage
extends ImporterProcessSupport.Database {
    protected final ProjectService projectService;
    protected final ProjectTypeManager projectTypeManager;
    private final ProjectManager projectManager;
    private List<String> externalProjectNames = Collections.emptyList();

    public TrelloProjectSelectionPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport ProjectService projectService, @ComponentImport ProjectTypeManager projectTypeManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.projectService = projectService;
        this.projectTypeManager = projectTypeManager;
        this.projectManager = projectManager;
    }

    public static String getFieldId(String boardName) {
        return ImporterProjectMappingsPage.getProjectFieldId((String)boardName);
    }

    private static String getProjectNameId(String boardName) {
        return TrelloProjectSelectionPage.getFieldId(boardName) + "-project-name";
    }

    private static String getProjectKeyId(String boardName) {
        return TrelloProjectSelectionPage.getFieldId(boardName) + "-project-key";
    }

    private static String getProjectSelectedId(String boardName) {
        return TrelloProjectSelectionPage.getFieldId(boardName) + "-project-selected";
    }

    public String doDefault() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        TrelloImporterConfigBean configBean = (TrelloImporterConfigBean)this.getConfigBean();
        if (configBean == null) {
            return "restartimporterneeded";
        }
        TrelloImporterClient client = configBean.getTrelloImporterClient();
        if (client == null) {
            return "restartimporterneeded";
        }
        OAuthService service = client.getService();
        Token requestToken = (Token)ActionContext.getSession().get("issue.importer.jira.bitbucket.oauthRequestToken");
        String token = request.getParameter("oauth_token");
        String verifier = request.getParameter("oauth_verifier");
        Token accessToken = null;
        if (token != null && verifier != null) {
            accessToken = service.getAccessToken(requestToken, new Verifier(verifier));
        }
        if (accessToken != null) {
            client.setAccessToken(accessToken);
        } else {
            this.addError("accessToken", this.getText("com.atlassian.jira.plugins.importer.trello.receiveOauthCode.error.userDeniedAccess"));
        }
        return super.doDefault();
    }

    public String getFormProjectName(String boardName) {
        String formValue = this.getHttpRequest().getParameter(TrelloProjectSelectionPage.getProjectNameId(boardName));
        if (formValue == null) {
            formValue = boardName;
        }
        return formValue;
    }

    public String getFormProjectKey(String boardName) {
        String formValue = this.getHttpRequest().getParameter(TrelloProjectSelectionPage.getProjectKeyId(boardName));
        if (formValue == null) {
            formValue = "";
        }
        return formValue;
    }

    public void appendError(String fieldName, String error) {
        if (this.getErrors().containsKey(fieldName)) {
            super.addError(fieldName, (String)this.getErrors().get(fieldName) + " " + error);
        } else {
            super.addError(fieldName, error);
        }
    }

    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        if (this.isPreviousClicked() || this.getConfigBean() == null) {
            return;
        }
        this.prepareModel();
        HashMap projectKeyMappings = Maps.newHashMap();
        for (String boardName : this.externalProjectNames) {
            String projectSelectedField = TrelloProjectSelectionPage.getProjectSelectedId(boardName);
            boolean projectSelected = this.getHttpRequest().getParameterMap().containsKey(projectSelectedField);
            if (!projectSelected) continue;
            String projectNameField = TrelloProjectSelectionPage.getProjectNameId(boardName);
            String projectKeyField = TrelloProjectSelectionPage.getProjectKeyId(boardName);
            String projectName = this.getHttpRequest().getParameter(projectNameField);
            String projectKey = this.getHttpRequest().getParameter(projectKeyField);
            if (projectName == null) {
                this.appendError(projectNameField, this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.noProjectName"));
                continue;
            }
            if (projectKey == null) {
                this.appendError(projectKeyField, this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.noProjectKey"));
                continue;
            }
            this.checkForDuplicateNameOrKey(projectKeyMappings, projectName, projectKey, boardName);
            ExternalProject externalProject = new ExternalProject(projectName, projectKey, this.getLoggedInApplicationUser().getName()).setExternalName(boardName);
            this.validateNewProject(externalProject);
            projectKeyMappings.put(boardName, externalProject);
        }
        this.getConfigBean().populateProjectKeyMappings((Map)projectKeyMappings);
    }

    public void prepareModel() {
        AbstractConfigBean2 configBean = this.getConfigBean();
        try {
            this.externalProjectNames = configBean.getExternalProjectNames();
        }
        catch (TrelloApiException e) {
            this.addErrorMessage(e.getLocalizedMessage());
        }
    }

    @Nullable
    public String getFormTitle() {
        return this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.formTitle");
    }

    @Nullable
    public String getFormDescription() {
        return this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.formDescription");
    }

    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-trello-plugin:trelloProjectSelectionPage");
    }

    private void checkForDuplicateNameOrKey(Map<String, ExternalProject> currentProjectKeyMappings, String projectName, String projectKey, String boardName) {
        for (ExternalProject externalProject : currentProjectKeyMappings.values()) {
            if (externalProject.getName().equals(projectName)) {
                this.appendError(TrelloProjectSelectionPage.getProjectNameId(boardName), this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.duplicateProjectName"));
                this.appendError(TrelloProjectSelectionPage.getProjectNameId(externalProject.getExternalName()), this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.duplicateProjectName"));
            }
            if (!externalProject.getKey().equals(projectKey)) continue;
            this.appendError(TrelloProjectSelectionPage.getProjectKeyId(boardName), this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.duplicateProjectKey"));
            this.appendError(TrelloProjectSelectionPage.getProjectKeyId(externalProject.getExternalName()), this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.duplicateProjectKey"));
        }
    }

    private void validateNewProject(ExternalProject externalProject) {
        boolean error = false;
        if (this.projectManager.getProjectObjByName(externalProject.getName()) != null) {
            this.appendError(TrelloProjectSelectionPage.getProjectNameId(externalProject.getExternalName()), this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.projectNameExists"));
            error = true;
        }
        if (this.projectManager.getProjectObjByKey(externalProject.getKey()) != null) {
            this.appendError(TrelloProjectSelectionPage.getProjectKeyId(externalProject.getExternalName()), this.getText("com.atlassian.jira.plugins.importer.trello.trelloProjectSelectionPage.error.projectKeyExists"));
            error = true;
        }
        if (!error) {
            ProjectCreationData data = new ProjectCreationData.Builder().withName(externalProject.getName()).withKey(externalProject.getKey()).withLead(this.getUserManager().getUserByName(externalProject.getLead())).withType(TrelloImporterClient.getDefaultProjectType()).build();
            ProjectService.CreateProjectValidationResult result = this.projectService.validateCreateProject(this.getLoggedInApplicationUser(), data);
            if (!result.isValid()) {
                Map errors = result.getErrorCollection().getErrors();
                if (!errors.isEmpty()) {
                    if (errors.containsKey("projectName")) {
                        this.appendError(TrelloProjectSelectionPage.getProjectNameId(externalProject.getExternalName()), (String)errors.get("projectName"));
                    }
                    if (errors.containsKey("projectKey")) {
                        this.appendError(TrelloProjectSelectionPage.getProjectKeyId(externalProject.getExternalName()), (String)errors.get("projectKey"));
                    }
                } else {
                    this.addErrorMessages(result.getErrorCollection().getErrorMessages());
                }
            }
        }
    }
}

