/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.transformers;

import com.atlassian.jira.util.AttachmentUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import webwork.config.Configuration;

public class AttachmentHelper {
    public UniqueFile getTemporaryUniqueFile(String filename) {
        File temporaryAttachmentDirectory = AttachmentUtils.getTemporaryAttachmentDirectory();
        long uniqueId = this.getUUID();
        String finalFilename = uniqueId + "_" + new File(filename).getName();
        File tempFile = new File(temporaryAttachmentDirectory, finalFilename);
        return new UniqueFile(tempFile, uniqueId);
    }

    public void copyURLToFile(String url, UniqueFile uniqueFile) throws IOException {
        FileUtils.copyURLToFile((URL)new URL(url), (File)uniqueFile.getFile());
    }

    public Long getMaxAttachmentSize() {
        return new Long(Configuration.getString((String)"webwork.multipart.maxSize"));
    }

    private long getUUID() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    public static class UniqueFile {
        private final File file;
        private final long id;

        public UniqueFile(File file, long id) {
            this.file = file;
            this.id = id;
        }

        public File getFile() {
            return this.file;
        }

        public long getId() {
            return this.id;
        }
    }
}

