/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.model;

import com.atlassian.jira.plugins.importer.trello.model.Action;
import com.atlassian.jira.plugins.importer.trello.model.Attachment;
import com.atlassian.jira.plugins.importer.trello.model.Checklist;
import com.atlassian.jira.plugins.importer.trello.model.Label;
import com.atlassian.jira.plugins.importer.trello.model.User;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class Card
implements Comparable<Card> {
    public static final Map<String, String> FIELDS_NAMES_TO_JIRA = Maps.newHashMap();
    private final String id;
    private final String name;
    private final boolean closed;
    private final String desc;
    private final DateTime due;
    private final String url;
    private final String idList;
    private final List<Label> labels;
    private final List<Attachment> attachments;
    private final List<Checklist> checklists;
    private final List<User> members;
    private final List<String> idMembersVoted;
    private final List<Action> actions;
    private final float pos;

    public Card(String id, String name, boolean closed, String desc, DateTime due, String url, String idList, List<Label> labels, List<Attachment> attachments, List<Checklist> checklists, List<User> members, List<String> idMembersVoted, List<Action> actions, float pos) {
        this.id = id;
        this.name = name;
        this.closed = closed;
        this.desc = desc;
        this.due = due;
        this.url = url;
        this.idList = idList;
        this.labels = labels;
        this.attachments = attachments;
        this.checklists = checklists;
        this.members = members;
        this.idMembersVoted = idMembersVoted;
        this.actions = actions;
        this.pos = pos;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getDesc() {
        return this.desc;
    }

    public DateTime getDue() {
        return this.due;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<Checklist> getChecklists() {
        return this.checklists;
    }

    public List<String> getIdMembersVoted() {
        return this.idMembersVoted;
    }

    public String toString() {
        return "Card{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", closed=" + this.closed + ", desc='" + this.desc + '\'' + ", due=" + this.due + ", url='" + this.url + '\'' + ", idList='" + this.idList + '\'' + ", labels=" + this.labels + ", attachments=" + this.attachments + ", checklists=" + this.checklists + ", members=" + this.members + ", idMembersVoted=" + this.idMembersVoted + ", actions=" + this.actions + '}';
    }

    public List<User> getMembers() {
        return this.members;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public String getIdList() {
        return this.idList;
    }

    public Float getPos() {
        return Float.valueOf(this.pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card card = (Card)o;
        if (this.closed != card.closed) {
            return false;
        }
        if (this.actions != null ? !this.actions.equals(card.actions) : card.actions != null) {
            return false;
        }
        if (this.attachments != null ? !this.attachments.equals(card.attachments) : card.attachments != null) {
            return false;
        }
        if (this.checklists != null ? !this.checklists.equals(card.checklists) : card.checklists != null) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(card.desc) : card.desc != null) {
            return false;
        }
        if (this.due != null ? !this.due.equals((Object)card.due) : card.due != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(card.id) : card.id != null) {
            return false;
        }
        if (this.idList != null ? !this.idList.equals(card.idList) : card.idList != null) {
            return false;
        }
        if (this.idMembersVoted != null ? !this.idMembersVoted.equals(card.idMembersVoted) : card.idMembersVoted != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(card.labels) : card.labels != null) {
            return false;
        }
        if (this.members != null ? !this.members.equals(card.members) : card.members != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(card.name) : card.name != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(card.url) : card.url != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.closed ? 1 : 0);
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 31 * result + (this.due != null ? this.due.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.idList != null ? this.idList.hashCode() : 0);
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        result = 31 * result + (this.attachments != null ? this.attachments.hashCode() : 0);
        result = 31 * result + (this.checklists != null ? this.checklists.hashCode() : 0);
        result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
        result = 31 * result + (this.idMembersVoted != null ? this.idMembersVoted.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Card o) {
        return this.getPos().compareTo(o.getPos());
    }

    static {
        FIELDS_NAMES_TO_JIRA.put("name", "summary");
        FIELDS_NAMES_TO_JIRA.put("desc", "description");
        FIELDS_NAMES_TO_JIRA.put("due", "duedate");
    }
}

