/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.model;

import java.util.List;
import org.joda.time.DateTime;

public class Attachment {
    private final String id;
    private final long bytes;
    private final DateTime date;
    private final String idMember;
    private final String isUpload;
    private final String mimeType;
    private final String name;
    private final List<Preview> previews;
    private final String url;

    public Attachment(String id, long bytes, DateTime date, String idMember, String upload, String mimeType, String name, List<Preview> previews, String url) {
        this.id = id;
        this.bytes = bytes;
        this.date = date;
        this.idMember = idMember;
        this.isUpload = upload;
        this.mimeType = mimeType;
        this.name = name;
        this.previews = previews;
        this.url = url;
    }

    public String toString() {
        return "Attachment{id='" + this.id + '\'' + ", bytes=" + this.bytes + ", date=" + this.date + ", idMember='" + this.idMember + '\'' + ", isUpload='" + this.isUpload + '\'' + ", mimeType='" + this.mimeType + '\'' + ", name='" + this.name + '\'' + ", previews=" + this.previews + ", url='" + this.url + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public long getBytes() {
        return this.bytes;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getIdMember() {
        return this.idMember;
    }

    public String getUpload() {
        return this.isUpload;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public List<Preview> getPreviews() {
        return this.previews;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment that = (Attachment)o;
        if (this.bytes != that.bytes) {
            return false;
        }
        if (this.date != null ? !this.date.equals((Object)that.date) : that.date != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.idMember != null ? !this.idMember.equals(that.idMember) : that.idMember != null) {
            return false;
        }
        if (this.isUpload != null ? !this.isUpload.equals(that.isUpload) : that.isUpload != null) {
            return false;
        }
        if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.previews != null ? !this.previews.equals(that.previews) : that.previews != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.bytes ^ this.bytes >>> 32);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.idMember != null ? this.idMember.hashCode() : 0);
        result = 31 * result + (this.isUpload != null ? this.isUpload.hashCode() : 0);
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.previews != null ? this.previews.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public static class Preview {
        private final long width;
        private final long height;
        private final String url;
        private final String _id;

        public Preview(long width, long height, String url, String _id) {
            this.width = width;
            this.height = height;
            this.url = url;
            this._id = _id;
        }

        public String toString() {
            return "Preview{width=" + this.width + ", height=" + this.height + ", url='" + this.url + '\'' + ", _id='" + this._id + '\'' + '}';
        }

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public String getUrl() {
            return this.url;
        }

        public String get_id() {
            return this._id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Preview)) {
                return false;
            }
            Preview preview = (Preview)o;
            if (this.height != preview.height) {
                return false;
            }
            if (this.width != preview.width) {
                return false;
            }
            if (this._id != null ? !this._id.equals(preview._id) : preview._id != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(preview.url) : preview.url != null);
        }

        public int hashCode() {
            int result = (int)(this.width ^ this.width >>> 32);
            result = 31 * result + (int)(this.height ^ this.height >>> 32);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this._id != null ? this._id.hashCode() : 0);
            return result;
        }
    }
}

