/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.fetch;

import com.atlassian.jira.plugins.importer.trello.fetch.ParserUtils;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloParseException;
import com.atlassian.jira.plugins.importer.trello.model.Action;
import com.atlassian.jira.plugins.importer.trello.model.Board;
import com.atlassian.jira.plugins.importer.trello.model.Card;
import com.atlassian.jira.plugins.importer.trello.model.ChecklistItem;
import com.atlassian.jira.plugins.importer.trello.model.TrelloList;
import com.atlassian.jira.plugins.importer.trello.model.User;
import com.atlassian.jira.util.I18nHelper;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.joda.time.DateTime;

public class TrelloParser {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().registerTypeAdapter(DateTime.class, ParserUtils.DATE_TIME_JSON_DESERIALIZER).registerTypeAdapter(ChecklistItem.State.class, ParserUtils.CHECKLIST_ITEM_STATE_DESERIALIZER).registerTypeAdapter(Action.class, ParserUtils.ACTION_DESERIALIZER).serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setPrettyPrinting().create();
    private final I18nHelper i18nHelper;

    public TrelloParser(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public List<Board> getBoards(String boardListJson) {
        try {
            return (List)gson.fromJson(boardListJson, new TypeToken<List<Board>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            throw new TrelloParseException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.getBoards", boardListJson), (Exception)((Object)e));
        }
    }

    public Board getBoard(String boardJson) {
        try {
            return (Board)gson.fromJson(boardJson, Board.class);
        }
        catch (JsonSyntaxException e) {
            throw new TrelloParseException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.getBoards", boardJson), (Exception)((Object)e));
        }
    }

    public List<User> getUsers(String userListJson) {
        try {
            return (List)gson.fromJson(userListJson, new TypeToken<List<User>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            throw new TrelloParseException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.getUsers", userListJson), (Exception)((Object)e));
        }
    }

    public User getUser(String userJson) {
        try {
            return (User)gson.fromJson(userJson, User.class);
        }
        catch (JsonSyntaxException e) {
            throw new TrelloParseException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.getUser", userJson), (Exception)((Object)e));
        }
    }

    public List<Card> getCards(String cardListJson) {
        try {
            return (List)gson.fromJson(cardListJson, new TypeToken<List<Card>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            throw new TrelloParseException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.getCards", cardListJson), (Exception)((Object)e));
        }
    }

    public TrelloList getList(String listJson) {
        try {
            return (TrelloList)gson.fromJson(listJson, TrelloList.class);
        }
        catch (JsonSyntaxException e) {
            throw new TrelloParseException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.getList", listJson), (Exception)((Object)e));
        }
    }
}

