/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.fetch;

import com.atlassian.jira.plugins.importer.trello.fetch.TimeoutTuner;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloApiConnectionException;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloApiException;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloInvalidResponseException;
import com.atlassian.jira.plugins.importer.trello.model.Board;
import com.atlassian.jira.plugins.importer.trello.model.Card;
import com.atlassian.jira.plugins.importer.trello.model.User;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.scribe.builder.api.TrelloApi;
import org.scribe.exceptions.OAuthConnectionException;
import org.scribe.model.OAuthRequest;
import org.scribe.model.RequestTuner;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public class TrelloApiImpl
extends TrelloApi {
    private static final Logger systemLog = Logger.getLogger(TrelloApiImpl.class);
    private static final String TRELLO_API_URL = "https://api.trello.com/1";
    private static final String JIRA_IMPORTER_NAME = "Jira Importer for Trello";
    private static final String GET_BOARDS_FOR_USER_REQUEST = "/members/%s/boards?lists=all";
    private static final String GET_BOARD_REQUEST = "/boards/%s?fields=id,name,desc,url&lists=all";
    private static final String GET_USERS_FOR_BOARD_REQUEST = "/boards/%s/members?fields=id,username,fullName";
    private static final String GET_CURRENT_USER_REQUEST = "/members/me?fields=id,username,fullName";
    private static final String GET_USER_REQUEST = "/members/%s?fields=id,username,fullName";
    private static final String GET_CARDS_FOR_BOARD_REQUEST = "/boards/%s/cards?filter=all&attachments=true&checkItemStates=true&checklists=all&actions=all&members=true&member_fields=all";
    private static final String GET_LIST_REQUEST = "/lists/%s?fields=id,name,closed,pos";
    private final RequestTuner timeoutRequestTuner = new TimeoutTuner(60, TimeUnit.SECONDS);
    private final I18nHelper i18nHelper;
    private OAuthService service;
    private Token accessToken;
    private final CacheLoader<String, Optional<String>> USER_CACHE_LOADER = new CacheLoader<String, Optional<String>>(){

        public Optional<String> load(String userId) {
            try {
                return Optional.fromNullable((Object)TrelloApiImpl.this.makeRequest(TrelloApiImpl.this.buildRequest(TrelloApiImpl.GET_USER_REQUEST, userId), false));
            }
            catch (TrelloInvalidResponseException e) {
                if (e.getResponse().getCode() == 404) {
                    return Optional.absent();
                }
                return Optional.fromNullable((Object)(e.getResponse().getCode() + ": " + e.getResponse().getBody().trim()));
            }
        }
    };
    private final CacheLoader<String, String> LIST_CAHCE_LOADER = new CacheLoader<String, String>(){

        public String load(String listId) {
            return TrelloApiImpl.this.makeRequest(TrelloApiImpl.this.buildRequest(TrelloApiImpl.GET_LIST_REQUEST, listId));
        }
    };
    private final CacheLoader<String, String> BOARD_CACHE_LOADER = new CacheLoader<String, String>(){

        public String load(String boardId) {
            return TrelloApiImpl.this.makeRequest(TrelloApiImpl.this.buildRequest(TrelloApiImpl.GET_BOARD_REQUEST, boardId));
        }
    };
    private final Cache<String, Optional<String>> userCache;
    private final Cache<String, String> listCache;
    private final Cache<String, String> boardCache;

    public TrelloApiImpl() {
        this(null);
    }

    public TrelloApiImpl(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.userCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.USER_CACHE_LOADER);
        this.listCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.LIST_CAHCE_LOADER);
        this.boardCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.BOARD_CACHE_LOADER);
    }

    public String getAuthorizationUrl(Token requestToken) {
        try {
            return super.getAuthorizationUrl(requestToken) + "&scope=read&name=" + URLEncoder.encode(JIRA_IMPORTER_NAME, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.unsupportedEncoding"));
        }
    }

    protected String makeRequest(OAuthRequest request) {
        return this.makeRequest(request, true);
    }

    protected String makeRequest(OAuthRequest request, boolean ignoreError) {
        this.service.signRequest(this.accessToken, request);
        try {
            Response response = request.send(this.timeoutRequestTuner);
            if (ignoreError || response.isSuccessful()) {
                return response.getBody().trim();
            }
            throw new TrelloInvalidResponseException(response);
        }
        catch (OAuthConnectionException e) {
            systemLog.warn((Object)(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiConnectionError.error", e.getLocalizedMessage()) + " @ " + TRELLO_API_URL));
            throw new TrelloApiConnectionException((Exception)((Object)e), this.i18nHelper);
        }
    }

    @VisibleForTesting
    OAuthRequest buildRequest(String urlSuffix, String ... args) {
        Object[] encodedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            try {
                encodedArgs[i] = URLEncoder.encode(args[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.trelloApiImpl.error.unsupportedEncoding"));
            }
        }
        return new OAuthRequest(Verb.GET, TRELLO_API_URL + String.format(urlSuffix, encodedArgs));
    }

    public String getBoards(String userId) {
        return this.makeRequest(this.buildRequest(GET_BOARDS_FOR_USER_REQUEST, userId));
    }

    public String getBoards(User user) {
        return this.getBoards(user.getId());
    }

    public String getBoard(String boardId) {
        try {
            return TrelloApiImpl.getFromCache(this.boardCache, boardId);
        }
        catch (Exception e) {
            throw new TrelloApiException(e.getLocalizedMessage(), e);
        }
    }

    public String getUsers(String boardId) {
        return this.makeRequest(this.buildRequest(GET_USERS_FOR_BOARD_REQUEST, boardId));
    }

    public String getUsers(Board board) {
        return this.getUsers(board.getId());
    }

    public String getCurrentUser() {
        return this.makeRequest(this.buildRequest(GET_CURRENT_USER_REQUEST, new String[0]));
    }

    public String getUser(String userId) {
        try {
            Optional<String> stringOptional = TrelloApiImpl.getFromCache(this.userCache, userId);
            return stringOptional.isPresent() ? (String)stringOptional.get() : null;
        }
        catch (Exception e) {
            throw new TrelloApiException(e.getLocalizedMessage(), e);
        }
    }

    public String getCards(String boardId) {
        return this.makeRequest(this.buildRequest(GET_CARDS_FOR_BOARD_REQUEST, boardId));
    }

    public String getCards(Board board) {
        return this.getCards(board.getId());
    }

    public String getList(String listId) {
        try {
            return TrelloApiImpl.getFromCache(this.listCache, listId);
        }
        catch (Exception e) {
            throw new TrelloApiException(e.getLocalizedMessage(), e);
        }
    }

    public String getList(Card card) {
        return this.getList(card.getIdList());
    }

    public void setAccessToken(Token accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthService getService() {
        return this.service;
    }

    public void setService(OAuthService service) {
        this.service = service;
    }

    private static <V, K> V getFromCache(Cache<K, V> cachedResults, K key) {
        try {
            return (V)((LoadingCache)cachedResults).get(key);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}

