/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.agileutils;

import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManager;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerAccessor;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerServiceFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BoardManagerAccessorImpl
implements BoardManagerAccessor {
    private static final Logger log = LoggerFactory.getLogger(BoardManagerAccessorImpl.class);
    private static final String REQUIRED_SERVICE_CLASS = "com.pyxis.greenhopper.GreenHopper";
    private static final String SERVICE_FACTORY_CLASS = "com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerServiceFactory";
    private final ApplicationContext applicationContext;
    private BoardManager boardManager;

    @Autowired
    public BoardManagerAccessorImpl(@ComponentImport ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized BoardManager getBoardManager() {
        if (this.boardManager == null) {
            this.initRapidBoardManager();
        }
        return this.boardManager;
    }

    private void initRapidBoardManager() {
        try {
            Class<?> rapidBoardManagerServiceFactoryClass = this.getRapidBoardManagerServiceFactoryClass();
            if (rapidBoardManagerServiceFactoryClass != null) {
                this.boardManager = ((BoardManagerServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(rapidBoardManagerServiceFactoryClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create BoardManager", (Throwable)e);
        }
    }

    private Class<?> getRapidBoardManagerServiceFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass(REQUIRED_SERVICE_CLASS);
            return this.getClass().getClassLoader().loadClass(SERVICE_FACTORY_CLASS);
        }
        catch (Exception e) {
            log.info("The necessary JIRA Agile class is unavailable.");
            return null;
        }
    }
}

