/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.agileutils;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.api.rapid.view.Column;
import com.atlassian.greenhopper.api.rapid.view.QuickFilter;
import com.atlassian.greenhopper.api.rapid.view.RapidViewCreationService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.importer.trello.name.SearchRequestFilterCopyNameFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pyxis.greenhopper.GreenHopper;
import com.pyxis.greenhopper.jira.license.GreenHopperLicenseManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class BoardManager {
    private static final Logger log = Logger.getLogger(BoardManager.class);
    private final GreenHopper greenHopper;
    private final SearchRequestService searchRequestService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ConstantsManager constantsManager;
    private final I18nHelper i18nHelper;
    private final SearchRequestFilterCopyNameFactory searchRequestFilterCopyNameFactory;

    public BoardManager(GreenHopper greenHopper, SearchRequestService searchRequestService, JiraAuthenticationContext jiraAuthenticationContext, ConstantsManager constantsManager, I18nHelper i18nHelper, SearchRequestFilterCopyNameFactory searchRequestFilterCopyNameFactory) {
        this.greenHopper = greenHopper;
        this.searchRequestService = searchRequestService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.constantsManager = constantsManager;
        this.i18nHelper = i18nHelper;
        this.searchRequestFilterCopyNameFactory = searchRequestFilterCopyNameFactory;
    }

    public JiraAgileStatus getJiraAgileStatus() {
        try {
            GreenHopperLicenseManager licenseManager = (GreenHopperLicenseManager)ComponentAccessor.getOSGiComponentInstanceOfType(GreenHopperLicenseManager.class);
            if (licenseManager == null) {
                return JiraAgileStatus.DISABLED;
            }
            try {
                licenseManager.verify();
                return JiraAgileStatus.LICENSED;
            }
            catch (LicenseException e) {
                return JiraAgileStatus.ENABLED;
            }
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)"GreenHopper plugin is enabled, but GreenHopperLicenseManager could not be found!");
            return JiraAgileStatus.DISABLED;
        }
    }

    public boolean isJiraAgileEnabled() {
        return this.getJiraAgileStatus().equals((Object)JiraAgileStatus.ENABLED);
    }

    public boolean isJiraAgileLicensed() {
        return this.getJiraAgileStatus().equals((Object)JiraAgileStatus.LICENSED);
    }

    public boolean isJiraAgileDisabled() {
        return this.getJiraAgileStatus().equals((Object)JiraAgileStatus.DISABLED);
    }

    public CustomField getRankField() {
        RankService rankService = (RankService)ComponentAccessor.getOSGiComponentInstanceOfType(RankService.class);
        if (rankService != null) {
            return (CustomField)Iterables.getFirst((Iterable)rankService.getRankFields(), null);
        }
        return null;
    }

    public long createRapidBoard(Project project, Collection<String> columnNames) throws BoardCreationException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RapidViewCreationService rapidViewCreationService = (RapidViewCreationService)ComponentAccessor.getOSGiComponentInstanceOfType(RapidViewCreationService.class);
        String rapidBoardName = this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.agileutils.rapidBoardManager.rapidBoardName", project.getKey());
        if (rapidViewCreationService == null) {
            throw new DependencyNotPresentException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.agileutils.rapidBoardManager.jiraAgileApiNotPresent"));
        }
        if (this.getRankField() == null) {
            throw new BoardCreationException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.agileutils.rapidBoardManager.rankFieldNotPresent"));
        }
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser());
        String baseFilterName = this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.agileutils.rapidBoardManager.filterName", rapidBoardName);
        String filterName = this.searchRequestFilterCopyNameFactory.createFrom(baseFilterName);
        SearchRequest filter = new SearchRequest();
        filter.setName(filterName);
        filter.setOwner(this.jiraAuthenticationContext.getUser());
        filter.setPermissions(SharedEntity.SharePermissions.GLOBAL);
        filter.setQuery(JqlQueryBuilder.newBuilder().where().project(new String[]{project.getKey()}).and().sub().fixVersionIsEmpty().or().fixVersion().inFunc("unreleasedVersions").endsub().endWhere().orderBy().addSortForFieldName(this.getRankField().getId(), SortOrder.ASC, true).buildQuery());
        filter = this.searchRequestService.createFilter((JiraServiceContext)jiraServiceContext, filter);
        if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            throw new BoardCreationException(jiraServiceContext.getErrorCollection().toString());
        }
        Long viewId = rapidViewCreationService.createNewRapidView(jiraServiceContext.getLoggedInApplicationUser().getDirectoryUser(), rapidBoardName, filter.getId().longValue(), (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new BoardCreationException(errors.toString());
        }
        ArrayList rapidBoardColumns = Lists.newArrayList();
        for (String columnName : columnNames) {
            for (Status status : this.constantsManager.getStatusObjects()) {
                if (!columnName.equalsIgnoreCase(status.getName())) continue;
                rapidBoardColumns.add(new Column(columnName, (List)Lists.newArrayList((Object[])new Status[]{status})));
            }
        }
        rapidViewCreationService.setStatusMappings(jiraServiceContext.getLoggedInApplicationUser().getDirectoryUser(), viewId.longValue(), (List)rapidBoardColumns, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new BoardCreationException(errors.toString());
        }
        rapidViewCreationService.setSwimlanes(jiraServiceContext.getLoggedInApplicationUser().getDirectoryUser(), viewId.longValue(), (List)Lists.newArrayList(), (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new BoardCreationException(errors.toString());
        }
        ArrayList quickFilters = Lists.newArrayList((Object[])new QuickFilter[]{new QuickFilter(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.agileutils.rapidBoardManager.quickFilterName.myIssues"), "assignee = currentUser()"), new QuickFilter(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.agileutils.rapidBoardManager.quickFilterName.recentlyUpdated"), "updatedDate >= -1d")});
        rapidViewCreationService.setQuickFilters(jiraServiceContext.getLoggedInApplicationUser().getDirectoryUser(), viewId.longValue(), (List)quickFilters, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new BoardCreationException(errors.toString());
        }
        return viewId;
    }

    public static class BoardCreationException
    extends Exception {
        public BoardCreationException(String message) {
            super(message);
        }

        public BoardCreationException(String message, Exception context) {
            super(message, context);
        }
    }

    public static class DependencyNotPresentException
    extends RuntimeException {
        public DependencyNotPresentException(String message) {
            super(message);
        }

        public DependencyNotPresentException(String message, Exception context) {
            super(message, context);
        }
    }

    public static enum JiraAgileStatus {
        DISABLED,
        ENABLED,
        LICENSED;

    }
}

