/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.trello.WorkflowHelper;
import com.atlassian.jira.plugins.importer.trello.model.Board;
import com.atlassian.jira.plugins.importer.trello.model.TrelloList;
import com.atlassian.jira.plugins.importer.trello.name.WorkflowSchemeCopyNameFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.function.event.FireIssueEventFunction;
import com.atlassian.jira.workflow.function.issue.IssueCreateFunction;
import com.atlassian.jira.workflow.function.issue.IssueReindexFunction;
import com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction;
import com.atlassian.jira.workflow.names.WorkflowCopyNameFactory;
import com.atlassian.jira.workflow.validator.PermissionValidator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowHelperImpl
implements WorkflowHelper {
    private static final String ARCHIVED_RESOLUTION = "Archived";
    private static final String DEFAULT_STATUS_ICON = "/images/icons/statuses/generic.png";
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final StatusManager statusManager;
    private final I18nHelper i18nHelper;
    private final ResolutionManager resolutionManager;
    private final DefaultPostFunctionPredicate defaultPostFunctionPredicate;
    private final PluginAccessor pluginAccessor;
    private WorkflowCopyNameFactory workflowCopyNameFactory;

    @Autowired
    public WorkflowHelperImpl(@ComponentImport WorkflowManager workflowManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport StatusManager statusManager, @ComponentImport I18nHelper i18nHelper, @ComponentImport ResolutionManager resolutionManager, @ComponentImport ModuleDescriptorFactory moduleDescriptorFactory, @ComponentImport PluginAccessor pluginAccessor) {
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.workflowSchemeManager = workflowSchemeManager;
        this.statusManager = statusManager;
        this.i18nHelper = i18nHelper;
        this.resolutionManager = resolutionManager;
        this.defaultPostFunctionPredicate = new DefaultPostFunctionPredicate(moduleDescriptorFactory, pluginAccessor);
        this.pluginAccessor = pluginAccessor;
        this.workflowCopyNameFactory = (WorkflowCopyNameFactory)ComponentAccessor.getOSGiComponentInstanceOfType(WorkflowCopyNameFactory.class);
    }

    @Autowired(required=false)
    public void setWorkflowCopyNameFactory(@ComponentImport WorkflowCopyNameFactory workflowCopyNameFactory) {
        this.workflowCopyNameFactory = workflowCopyNameFactory;
    }

    @Override
    public String createWorkflowForBoard(ExternalProject project, Board board) {
        JiraWorkflow workflow = this.createWorkflow(project, board);
        WorkflowScheme workflowScheme = this.createWorkflowScheme(this.getWorkflowSchemeName(project), workflow);
        return workflowScheme.getName();
    }

    public String getWorkflowSchemeName(ExternalProject project) {
        return this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.workflowSchemeName", project.getName());
    }

    @VisibleForTesting
    WorkflowScheme createWorkflowScheme(String name, JiraWorkflow workflow) {
        AssignableWorkflowScheme existingWorkflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(name);
        String workflowSchemeName = name;
        if (existingWorkflowScheme != null) {
            if (existingWorkflowScheme.getActualDefaultWorkflow().equals(workflow.getName())) {
                return existingWorkflowScheme;
            }
            WorkflowSchemeCopyNameFactory workflowSchemeCopyNameFactory = new WorkflowSchemeCopyNameFactory(this.i18nHelper, this.workflowSchemeManager);
            workflowSchemeName = workflowSchemeCopyNameFactory.createFrom(workflowSchemeName);
        }
        try {
            AssignableWorkflowScheme.Builder newWorkflowSchemeBuilder = this.workflowSchemeManager.assignableBuilder();
            newWorkflowSchemeBuilder.setName(workflowSchemeName);
            newWorkflowSchemeBuilder.setDefaultWorkflow(workflow.getName());
            AssignableWorkflowScheme newWorkflowScheme = this.workflowSchemeManager.createScheme(newWorkflowSchemeBuilder.build());
            return newWorkflowScheme;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean workflowContainsSteps(JiraWorkflow workflow, Collection<String> steps) {
        for (Object stepObject : workflow.getDescriptor().getSteps()) {
            StepDescriptor step = (StepDescriptor)stepObject;
            if (steps.contains(step.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean workflowContainsStep(WorkflowDescriptor workflowDescriptor, String stepName) {
        for (Object stepObject : workflowDescriptor.getSteps()) {
            StepDescriptor step = (StepDescriptor)stepObject;
            if (!step.getName().equals(stepName)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    JiraWorkflow createWorkflow(ExternalProject project, Board board) {
        String workflowName = this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.workflowName", project.getName());
        LinkedList steps = Lists.newLinkedList();
        for (TrelloList list : board.getLists()) {
            steps.add(list.getName());
        }
        if (this.workflowManager.workflowExists(workflowName)) {
            LinkedList completeSteps = Lists.newLinkedList((Iterable)steps);
            completeSteps.add(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.archivedStatusName"));
            if (!this.workflowContainsSteps(this.workflowManager.getWorkflow(workflowName), completeSteps)) {
                workflowName = this.workflowCopyNameFactory.createFrom(workflowName, this.authenticationContext.getLocale());
            } else {
                return this.workflowManager.getWorkflow(workflowName);
            }
        }
        WorkflowDescriptor workflowDescriptor = this.createInitialTrelloWorkflowDescriptor(steps.size());
        int stepId = 0;
        int actionId = workflowDescriptor.getGlobalActions().size() + workflowDescriptor.getInitialActions().size() + workflowDescriptor.getCommonActions().size();
        for (int i = 0; i < steps.size(); ++i) {
            String stepName = (String)steps.get(i);
            if (this.workflowContainsStep(workflowDescriptor, stepName)) continue;
            StepDescriptor step = this.createStep(stepName, stepId);
            step.setParent((AbstractDescriptor)workflowDescriptor);
            workflowDescriptor.addStep(step);
            ActionDescriptor action = this.createGlobalTransition(step, actionId);
            action.setParent((AbstractDescriptor)workflowDescriptor);
            workflowDescriptor.addGlobalAction(action);
            if (i == steps.size() - 1) {
                this.addArchivePostFunctions(action);
            } else {
                this.addStandardPostFunctions(action);
            }
            this.addCommonPostFunctions(action);
            ++stepId;
            ++actionId;
        }
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(workflowName, workflowDescriptor, this.workflowManager);
        newWorkflow.setDescription(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.workflowDescription", board.getName()));
        this.workflowManager.createWorkflow(this.authenticationContext.getUser(), (JiraWorkflow)newWorkflow);
        return newWorkflow;
    }

    private WorkflowDescriptor createInitialTrelloWorkflowDescriptor(int nsteps) {
        WorkflowDescriptor workflowDescriptor = DescriptorFactory.getFactory().createWorkflowDescriptor();
        ActionDescriptor initialAction = DescriptorFactory.getFactory().createActionDescriptor();
        initialAction.setId(0);
        initialAction.setName(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.initialActionName"));
        initialAction.setParent((AbstractDescriptor)workflowDescriptor);
        initialAction.getValidators().add(PermissionValidator.makeDescriptor((String)Permissions.getShortName((int)11)));
        workflowDescriptor.addInitialAction(initialAction);
        ResultDescriptor initialResult = DescriptorFactory.getFactory().createResultDescriptor();
        initialResult.setId(0);
        initialResult.setStep(0);
        initialResult.setStatus(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.archivedStatusName"));
        initialAction.setUnconditionalResult(initialResult);
        initialResult.getPostFunctions().add(IssueCreateFunction.makeDescriptor());
        initialResult.getPostFunctions().add(IssueReindexFunction.makeDescriptor());
        initialResult.getPostFunctions().add(FireIssueEventFunction.makeDescriptor((Long)EventType.ISSUE_CREATED_ID));
        StepDescriptor archiveStep = this.createStep(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.archivedStatusName"), nsteps);
        archiveStep.setParent((AbstractDescriptor)workflowDescriptor);
        workflowDescriptor.addStep(archiveStep);
        ActionDescriptor archiveAction = this.createGlobalTransition(archiveStep, 1);
        archiveAction.setName(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.archivedStatusTransition"));
        archiveAction.setParent((AbstractDescriptor)workflowDescriptor);
        workflowDescriptor.addGlobalAction(archiveAction);
        this.addArchivePostFunctions(archiveAction);
        this.addCommonPostFunctions(archiveAction);
        return workflowDescriptor;
    }

    private Status getStatus(String statusName) {
        for (Status status : this.statusManager.getStatuses()) {
            if (!statusName.equalsIgnoreCase(status.getName())) continue;
            return status;
        }
        return null;
    }

    private StepDescriptor createStep(String stepName, int stepId) {
        Status status = this.getStatus(stepName);
        if (status == null) {
            status = this.statusManager.createStatus(stepName, "", DEFAULT_STATUS_ICON);
        }
        StepDescriptor step = DescriptorFactory.getFactory().createStepDescriptor();
        step.setId(stepId);
        step.setName(stepName);
        step.getMetaAttributes().put("jira.status.id", status.getId());
        return step;
    }

    private void addArchivePostFunctions(ActionDescriptor action) {
        Resolution resolution = this.resolutionManager.getDefaultResolution();
        if (resolution == null) {
            List resolutions = this.resolutionManager.getResolutions();
            resolution = resolutions.isEmpty() ? this.resolutionManager.createResolution(ARCHIVED_RESOLUTION, ARCHIVED_RESOLUTION) : (Resolution)resolutions.get(0);
        }
        ResultDescriptor result = action.getUnconditionalResult();
        result.getPostFunctions().add(UpdateIssueFieldFunction.makeDescriptor((String)"resolution", (String)resolution.getId()));
        result.getPostFunctions().add(FireIssueEventFunction.makeDescriptor((Long)EventType.ISSUE_RESOLVED_ID));
        action.getValidators().add(PermissionValidator.makeDescriptor((String)Permissions.getShortName((int)14)));
    }

    private void addStandardPostFunctions(ActionDescriptor action) {
        action.getUnconditionalResult().getPostFunctions().add(UpdateIssueFieldFunction.makeDescriptor((String)"resolution", null));
    }

    private void addDefaultPostFunctions(ResultDescriptor result) {
        Collection defaultPostFunctionModuleDescriptors = this.pluginAccessor.getModuleDescriptors((ModuleDescriptorPredicate)this.defaultPostFunctionPredicate);
        TreeMap defaultPostFunctions = Maps.newTreeMap();
        for (ModuleDescriptor descriptor : defaultPostFunctionModuleDescriptors) {
            WorkflowFunctionModuleDescriptor postFunctionModule = (WorkflowFunctionModuleDescriptor)descriptor;
            WorkflowPluginFunctionFactory functionFactory = (WorkflowPluginFunctionFactory)postFunctionModule.getModule();
            Map parameters = functionFactory.getDescriptorParams(Collections.emptyMap());
            FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
            functionDescriptor.getArgs().put("class.name", postFunctionModule.getImplementationClass().getName());
            functionDescriptor.getArgs().putAll(parameters);
            functionDescriptor.setType("class");
            int weight = (Integer)Objects.firstNonNull((Object)postFunctionModule.getWeight(), (Object)Integer.MAX_VALUE);
            defaultPostFunctions.put(weight, functionDescriptor);
        }
        for (FunctionDescriptor postFunction : defaultPostFunctions.values()) {
            result.getPostFunctions().add(postFunction);
        }
    }

    private void addCommonPostFunctions(ActionDescriptor action) {
        action.getValidators().add(PermissionValidator.makeDescriptor((String)Permissions.getShortName((int)12)));
        this.addDefaultPostFunctions(action.getUnconditionalResult());
    }

    private ActionDescriptor createGlobalTransition(StepDescriptor toStep, int actionId) {
        ActionDescriptor action = DescriptorFactory.getFactory().createActionDescriptor();
        action.setId(actionId);
        action.setName(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.stepTransitionName", toStep.getName()));
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        result.setStep(toStep.getId());
        action.setUnconditionalResult(result);
        return action;
    }

    static class DefaultPostFunctionPredicate
    implements ModuleDescriptorPredicate<WorkflowPluginFunctionFactory> {
        private final EnabledModulePredicate<WorkflowPluginFunctionFactory> isEnabled;
        private final ModuleDescriptorOfTypePredicate<WorkflowPluginFunctionFactory> isPostFunction;

        public DefaultPostFunctionPredicate(ModuleDescriptorFactory moduleDescriptorFactory, PluginAccessor pluginAccessor) {
            this.isEnabled = new EnabledModulePredicate(pluginAccessor);
            this.isPostFunction = new ModuleDescriptorOfTypePredicate(moduleDescriptorFactory, "workflow-function");
        }

        public boolean matches(ModuleDescriptor<? extends WorkflowPluginFunctionFactory> moduleDescriptor) {
            boolean isEnabled = this.isEnabled.matches(moduleDescriptor);
            boolean isPostFunction = this.isPostFunction.matches(moduleDescriptor) && moduleDescriptor instanceof WorkflowFunctionModuleDescriptor;
            return isEnabled && isPostFunction && ((WorkflowFunctionModuleDescriptor)moduleDescriptor).isDefault();
        }
    }
}

