/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.web;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooServerAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.conditions.ProjectDevToolsIntegrationFeatureCondition;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.opensymphony.module.sitemesh.RequestConstants;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;

@Scanned
public class ViewBambooPanelContent
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger(ViewBambooPanelContent.class);
    private final ApplicationProperties applicationProperties;
    private final BambooServerAccessor bambooServerAccessor;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition;
    private final ProjectManager projectManager;
    private final SearchProvider searchProvider;
    private final VersionManager versionManager;
    private boolean showRss;
    private Long versionId;
    private String bambooHtml;
    private String issueKey;
    private String projectKey;
    private String redirectUrl;
    private String selectedSubTab;

    public ViewBambooPanelContent(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport IssueManager issueManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport SearchProvider searchProvider, @ComponentImport VersionManager versionManager, BambooServerAccessor bambooServerAccessor, ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.bambooServerAccessor = (BambooServerAccessor)Preconditions.checkNotNull((Object)bambooServerAccessor);
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectDevToolsIntegrationFeatureCondition = (ProjectDevToolsIntegrationFeatureCondition)Preconditions.checkNotNull((Object)projectDevToolsIntegrationFeatureCondition);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
        this.searchProvider = (SearchProvider)Preconditions.checkNotNull((Object)searchProvider);
        this.versionManager = (VersionManager)Preconditions.checkNotNull((Object)versionManager);
    }

    protected String doExecute() throws Exception {
        ActionContext.getRequest().setAttribute(RequestConstants.DECORATOR, (Object)"none");
        try {
            Project project;
            String selectedSubTab = this.getSelectedSubTab();
            String actionUrl = "planStatus".equals(selectedSubTab) ? "/ajax/build/viewPlansByJiraKey.action" : "/ajax/build/viewBuildResultsByJiraKey.action";
            MapBuilder extraParams = MapBuilder.newBuilder((Object)"selectedSubTab", (Object)selectedSubTab, (Object)"showRss", (Object)String.valueOf(this.showRss));
            if (this.issueKey != null) {
                MutableIssue issueObject = this.issueManager.getIssueObject(this.issueKey);
                if (issueObject != null && this.hasViewBambooPanelPermission(issueObject.getProjectObject())) {
                    this.setBambooHtml(this.bambooServerAccessor.getHtmlFromAction("/ajax/build/viewBuildResultsByJiraKey.action", issueObject.getProjectObject(), this.getIssueKeys((Issue)issueObject), extraParams.toMap()));
                }
            } else if (this.versionId != null) {
                Version version = this.versionManager.getVersion(this.versionId);
                if (version != null && this.hasViewBambooPanelPermission(version.getProject())) {
                    Collection<String> issueKeys = this.getIssueKeys(version);
                    if (issueKeys != null && !issueKeys.isEmpty()) {
                        Date releaseDate = version.getReleaseDate();
                        if (version.isReleased() && releaseDate != null) {
                            log.debug((Object)("Adding version release date " + releaseDate));
                            Calendar c = Calendar.getInstance();
                            c.setTime(releaseDate);
                            c.add(5, 1);
                            Date oneReleaseDate = c.getTime();
                            extraParams.add((Object)"releasedVersionTimestamp", (Object)String.valueOf(oneReleaseDate.getTime()));
                        }
                        this.setBambooHtml(this.bambooServerAccessor.getHtmlFromAction(actionUrl, version.getProject(), issueKeys, extraParams.toMap()));
                    } else {
                        this.setBambooHtml(this.getText("bamboo.panel.buildByDate.noJiraIssues"));
                    }
                }
            } else if (this.projectKey != null && (project = this.projectManager.getProjectObjByKey(this.projectKey)) != null && this.hasViewBambooPanelPermission(project)) {
                this.bambooHtml = this.bambooServerAccessor.getHtmlFromAction(actionUrl, project, extraParams.toMap());
            }
        }
        catch (CredentialsRequiredException e) {
            log.info((Object)"Credentials are required but cannot be found. Redirecting to authorization page.");
            String baseLinkUrl = ActionContext.getRequest().getParameter("baseLinkUrl");
            String jiraBaseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            String callbackUrl = jiraBaseUrl + baseLinkUrl;
            String redirect = e.getAuthorisationURI(URI.create(callbackUrl)).toASCIIString();
            this.setRedirectUrl(redirect);
            return "permissionviolation";
        }
        catch (Exception e) {
            log.warn((Object)"Unable to to connect to Bamboo server. Nothing will be shown.", (Throwable)e);
            this.addErrorMessage(this.getText("bamboo.panel.connection.error"));
            return "error";
        }
        return super.doExecute();
    }

    private boolean hasViewBambooPanelPermission(Project project) {
        Map<String, Project> projectContext = Collections.singletonMap("project", project);
        return this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, project, this.authenticationContext.getLoggedInUser()) && this.projectDevToolsIntegrationFeatureCondition.shouldDisplay(projectContext);
    }

    private Collection<String> getIssueKeys(Version version) {
        try {
            JqlQueryBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{version.getProject().getId()}).and().fixVersion(version.getId()).endWhere();
            SearchResults results = this.searchProvider.search(builder.buildQuery(), this.authenticationContext.getLoggedInUser(), PagerFilter.getUnlimitedFilter());
            List issues = results.getIssues();
            ArrayList issueKeys = Lists.newArrayListWithExpectedSize((int)issues.size());
            for (Issue issue : issues) {
                issueKeys.addAll(this.getIssueKeys(issue));
            }
            return issueKeys;
        }
        catch (SearchException e) {
            log.warn((Object)("Unable to get all issues from version " + version + ". Returning null."), (Throwable)e);
            return null;
        }
    }

    private Collection<String> getIssueKeys(Issue issue) {
        return this.issueManager.getAllIssueKeys(issue.getId());
    }

    public String getSelectedSubTab() {
        return this.selectedSubTab;
    }

    public void setSelectedSubTab(String selectedSubTab) {
        this.selectedSubTab = selectedSubTab;
    }

    @HtmlSafe
    public String getBambooHtml() {
        return this.bambooHtml;
    }

    private void setBambooHtml(String bambooHtml) {
        this.bambooHtml = bambooHtml == null ? "" : bambooHtml;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public boolean isShowRss() {
        return this.showRss;
    }

    public void setShowRss(boolean showRss) {
        this.showRss = showRss;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }
}

