/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.web;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.web.BambooWebActionSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;

@WebSudoRequired
public class EditBambooApplicationLink
extends BambooWebActionSupport {
    private final ProjectManager projectManager;
    private ApplicationLink applicationLink;
    private Iterable<String> associatedKeys;

    public EditBambooApplicationLink(BambooApplicationLinkManager applinkManager, ProjectManager projectManager, PageBuilderService jiraPageBuilderService) {
        super(jiraPageBuilderService, applinkManager);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
    }

    @Override
    public String doDefault() throws Exception {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        this.associatedKeys = this.getApplinkManager().getProjects(this.applicationLink.getId().get());
        return "input";
    }

    public void doValidation() {
        super.doValidation();
        for (String projectKey : this.associatedKeys) {
            Project project = this.projectManager.getProjectObjByKey(projectKey.toUpperCase());
            if (project == null) {
                this.addError("associatedKeys", this.getText("bamboo.config.project.doesNotExist", projectKey));
                continue;
            }
            if (!this.getApplinkManager().hasAssociatedApplicationLink(projectKey) || this.getApplinkManager().isAssociated(projectKey, this.applicationLink.getId())) continue;
            this.addError("associatedKeys", this.getText("bamboo.config.projectKey.duplicate", projectKey));
        }
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        if (this.hasAnyErrors()) {
            return "input";
        }
        this.getApplinkManager().unassociateAll(this.applicationLink.getId());
        for (String projectKey : this.associatedKeys) {
            this.getApplinkManager().associate(projectKey.toUpperCase(), this.applicationLink.getId());
        }
        return this.getRedirect("ViewBambooApplicationLinks.jspa");
    }

    public String getApplicationId() {
        return this.applicationLink.getId().get();
    }

    public void setApplicationId(String applicationId) {
        if (applicationId != null) {
            this.applicationLink = this.getApplinkManager().getBambooApplicationLink(applicationId);
        }
    }

    public String getAssociatedKeys() {
        return Joiner.on((String)" ").join((Iterable)this.getSorter().sort((Collection)ImmutableList.copyOf(this.associatedKeys)));
    }

    public void setAssociatedKeys(String associatedKeys) {
        this.associatedKeys = Iterables.filter((Iterable)ImmutableList.copyOf((Object[])associatedKeys.split(" ")), (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return key != null && !key.isEmpty();
            }
        });
    }

    public String getName() {
        if (this.applicationLink == null) {
            return "";
        }
        return this.applicationLink.getName();
    }

    public String getHost() {
        if (this.applicationLink == null) {
            return "";
        }
        return this.applicationLink.getDisplayUrl().toASCIIString();
    }
}

