/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.web;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.google.common.base.Preconditions;
import org.apache.velocity.tools.generic.SortTool;

@Scanned
public abstract class BambooWebActionSupport
extends JiraWebActionSupport {
    public static final String BAMBOO_PLUGIN_KEY = "com.atlassian.jira.plugin.ext.bamboo";
    private final BambooApplicationLinkManager applinkManager;
    private final SortTool sorter = new SortTool();
    private final WebResourceAssembler webResourceAssembler;

    protected BambooWebActionSupport(@ComponentImport PageBuilderService jiraPageBuilderService, BambooApplicationLinkManager applinkManager) {
        this.applinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)applinkManager);
        this.webResourceAssembler = ((PageBuilderService)Preconditions.checkNotNull((Object)jiraPageBuilderService)).assembler();
    }

    public boolean hasPermissions() {
        return this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER);
    }

    public boolean hasMultipleBambooApplinks() {
        return this.applinkManager.getApplicationLinkCount(BambooApplicationLinkManager.Filter.UNFILTERED) > 1;
    }

    public boolean hasBambooApplinks() {
        return this.applinkManager.hasApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED);
    }

    public Iterable<ApplicationLink> getBambooApplinks() {
        return this.applinkManager.getApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED);
    }

    public boolean hasProjectsAssociatedWithApplink(String applinkId) {
        return this.applinkManager.hasAssociatedProjects(applinkId);
    }

    public Iterable<String> getProjectsAssociatedWithApplink(String applinkId) {
        return this.applinkManager.getProjects(applinkId);
    }

    public String doDefault() throws Exception {
        return this.hasPermissions() ? "input" : "permissionviolation";
    }

    public String execute() throws Exception {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        this.webResourceAssembler.resources().requireWebResource("com.atlassian.jira.plugin.ext.bamboo:css");
        return super.execute();
    }

    public SortTool getSorter() {
        return this.sorter;
    }

    public BambooApplicationLinkManager getApplinkManager() {
        return this.applinkManager;
    }

    @HtmlSafe
    public String getText(String i18nKey) {
        return this.getI18nHelper().getText(i18nKey);
    }
}

