/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.view;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.BuildState;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.jira.plugin.viewissue.issuelink.DefaultIssueLinkRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.software.api.conditions.ProjectDevToolsIntegrationFeatureCondition;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Scanned
public class BuildLinkRenderer
extends DefaultIssueLinkRenderer {
    private static final Logger log = Logger.getLogger(BuildLinkRenderer.class);
    private static final String COMPONENT_KEY_I_18_N = "i18n";
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooRestService bambooRestService;
    private final IssueManager issueManager;
    private final ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition;

    public BuildLinkRenderer(@ComponentImport IssueManager issueManager, BambooApplicationLinkManager bambooApplicationLinkManager, BambooRestService bambooRestService, ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager);
        this.projectDevToolsIntegrationFeatureCondition = (ProjectDevToolsIntegrationFeatureCondition)Preconditions.checkNotNull((Object)projectDevToolsIntegrationFeatureCondition);
    }

    public Map<String, Object> getInitialContext(RemoteIssueLink remoteIssueLink, Map<String, Object> context) {
        I18nHelper i18n = (I18nHelper)context.get(COMPONENT_KEY_I_18_N);
        HashMap initialContext = Maps.newHashMap((Map)super.getInitialContext(remoteIssueLink, context));
        BuildLinkRenderer.fillContext(remoteIssueLink, i18n, BuildState.UNKNOWN, initialContext);
        return initialContext;
    }

    public Map<String, Object> getFinalContext(RemoteIssueLink remoteIssueLink, Map<String, Object> context) {
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        String projectKey = issue.getProjectObject().getKey();
        HashMap finalContext = Maps.newHashMap();
        ApplicationLink applicationLink = this.bambooApplicationLinkManager.getApplicationLink(projectKey);
        if (applicationLink != null) {
            ApplicationLinkRequestFactory authenticatedRequestFactory = applicationLink.createAuthenticatedRequestFactory();
            try {
                RestResult<Object> rr;
                boolean succeededFetchingStatus = false;
                BuildState buildState = null;
                RestResult<Object> restResult = null;
                if (remoteIssueLink.getGlobalId().contains("planResultKey")) {
                    rr = this.bambooRestService.getPlanResultStatus(authenticatedRequestFactory, PlanKeys.getPlanResultKey(remoteIssueLink.getSummary()));
                    PlanResultStatus planResultStatus = rr.getResult();
                    if (planResultStatus != null) {
                        succeededFetchingStatus = true;
                        buildState = planResultStatus.getBuildState();
                    }
                    restResult = rr;
                } else if (remoteIssueLink.getGlobalId().contains("planKey")) {
                    rr = this.bambooRestService.getPlanStatus(authenticatedRequestFactory, PlanKeys.getPlanKey(remoteIssueLink.getSummary()));
                    PlanStatus planStatus = (PlanStatus)rr.getResult();
                    if (planStatus != null) {
                        succeededFetchingStatus = true;
                        buildState = planStatus.getLatestBuildState();
                    }
                    restResult = rr;
                } else {
                    log.warn((Object)("Bamboo doesn't know how to render this link: " + remoteIssueLink.getGlobalId() + ".  Perhaps the default rendering will be fine."));
                }
                if (restResult != null) {
                    if (succeededFetchingStatus && restResult.getErrors().isEmpty()) {
                        finalContext.put("iconClass", buildState == null ? "NeverExecuted" : buildState);
                        I18nHelper i18n = (I18nHelper)context.get(COMPONENT_KEY_I_18_N);
                        BuildLinkRenderer.fillContext(remoteIssueLink, i18n, buildState, finalContext);
                    } else {
                        log.warn((Object)("Error when fetching Bamboo Plan status for key " + remoteIssueLink.getSummary() + " " + restResult.getErrors()));
                        finalContext.put("noApplinkAuthConfigured", Boolean.TRUE);
                    }
                }
            }
            catch (CredentialsRequiredException exception) {
                URI authorisationURI = exception.getAuthorisationURI();
                if (authorisationURI == null) {
                    finalContext.put("noApplinkAuthConfigured", Boolean.TRUE);
                }
                String applicationName = StringUtils.defaultIfEmpty((String)applicationLink.getName(), (String)"");
                finalContext.put("authenticationRequired", Boolean.TRUE);
                finalContext.put("authenticationUrl", exception.getAuthorisationURI());
                finalContext.put("applicationName", applicationName);
                finalContext.put("appLinkId", applicationLink.getId());
                finalContext.put("applicationUrl", applicationLink.getDisplayUrl());
                remoteIssueLink = new RemoteIssueLinkBuilder(remoteIssueLink).applicationName(applicationName).build();
            }
        }
        finalContext.putAll(super.getInitialContext(remoteIssueLink, context));
        return finalContext;
    }

    private static void fillContext(RemoteIssueLink remoteIssueLink, I18nHelper i18n, BuildState buildState, Map<String, Object> initialContext) {
        String i18nBuildState = i18n.getText("bamboo.build.state." + (buildState != null ? buildState.toString().toLowerCase() : "neverExecuted"));
        initialContext.put("iconTooltip", remoteIssueLink.getSummary() + " - " + i18nBuildState);
        initialContext.put("tooltip", "[" + remoteIssueLink.getApplicationName() + "] " + remoteIssueLink.getTitle());
    }

    public boolean requiresAsyncLoading(RemoteIssueLink remoteIssueLink) {
        return true;
    }

    public boolean shouldDisplay(RemoteIssueLink remoteIssueLink) {
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        Project project = issue.getProjectObject();
        ImmutableMap context = ImmutableMap.of((Object)"project", (Object)project);
        return super.shouldDisplay(remoteIssueLink) && this.projectDevToolsIntegrationFeatureCondition.shouldDisplay((Map)context);
    }
}

