/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.view;

import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.panel.BambooPanelHelper;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.plugin.versionpanel.impl.GenericTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.conditions.ProjectDevToolsIntegrationFeatureCondition;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

@Scanned
public abstract class BambooVersionTabPanel
extends GenericTabPanel {
    @VisibleForTesting
    static final String SHOW_FUSION_FEEDBACK_BANNERS_KEY = "showReleaseReportBanners";
    protected final BambooPanelHelper bambooPanelHelper;
    protected final BambooReleaseService bambooReleaseService;
    private final PermissionManager permissionManager;
    private final String moduleKey;
    private final ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition;

    protected BambooVersionTabPanel(@ComponentImport FieldVisibilityManager fieldVisibilityManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport SearchProvider searchProvider, ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition, BambooPanelHelper bambooPanelHelper, BambooReleaseService bambooReleaseService, String moduleKey) {
        super(authenticationContext, searchProvider, fieldVisibilityManager);
        this.bambooPanelHelper = (BambooPanelHelper)Preconditions.checkNotNull((Object)bambooPanelHelper);
        this.bambooReleaseService = (BambooReleaseService)Preconditions.checkNotNull((Object)bambooReleaseService);
        this.moduleKey = (String)Preconditions.checkNotNull((Object)moduleKey);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectDevToolsIntegrationFeatureCondition = (ProjectDevToolsIntegrationFeatureCondition)Preconditions.checkNotNull((Object)projectDevToolsIntegrationFeatureCondition);
    }

    public boolean showPanel(BrowseVersionContext context) {
        Map<String, Project> conditionContext = Collections.singletonMap("project", context.getProject());
        return super.showPanel(context) && this.projectDevToolsIntegrationFeatureCondition.shouldDisplay(conditionContext) && this.userHasViewVersionControlPermissions(context);
    }

    private boolean userHasViewVersionControlPermissions(BrowseVersionContext context) {
        return this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, context.getProject(), this.authenticationContext.getLoggedInUser());
    }

    protected final Map<String, Object> createVelocityParams(BrowseVersionContext context) {
        Map velocityParams = super.createVelocityParams(context);
        String baseLinkUrl = this.getBaseLinkUrl(context);
        String queryString = "versionId=" + context.getVersion().getId();
        velocityParams.put(SHOW_FUSION_FEEDBACK_BANNERS_KEY, this.showFusionFeedbackBanner());
        this.addVelocityParams(context, velocityParams);
        this.prepareVelocityContext(velocityParams, baseLinkUrl, queryString, context.getProject());
        return velocityParams;
    }

    protected boolean showFusionFeedbackBanner() {
        return false;
    }

    protected abstract void addVelocityParams(@Nonnull BrowseVersionContext var1, @Nonnull Map<String, Object> var2);

    protected abstract void prepareVelocityContext(Map<String, Object> var1, String var2, String var3, Project var4);

    protected final String getBaseLinkUrl(BrowseVersionContext context) {
        return "/browse/" + context.getProject().getKey() + "/fixforversion/" + context.getVersion().getId() + "?selectedTab=" + "com.atlassian.jira.plugin.ext.bamboo" + ":" + this.moduleKey;
    }

    protected final void resetReleaseStateIfVersionWasUnreleased(Version version) {
        this.bambooReleaseService.resetReleaseStateIfVersionWasUnreleased(version);
    }
}

