/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.view;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.ext.bamboo.panel.BambooPanelHelper;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

@Scanned
public class BambooReleaseReportButtonContextProvider
implements ContextProvider {
    private static final String MODULE_KEY = "";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final BambooPanelHelper bambooPanelHelper;
    private final BambooReleaseService bambooReleaseService;

    public BambooReleaseReportButtonContextProvider(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, BambooPanelHelper bambooPanelHelper, BambooReleaseService bambooReleaseService) {
        this.soyTemplateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)soyTemplateRenderer);
        this.bambooPanelHelper = (BambooPanelHelper)Preconditions.checkNotNull((Object)bambooPanelHelper);
        this.bambooReleaseService = (BambooReleaseService)Preconditions.checkNotNull((Object)bambooReleaseService);
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        User user = ApplicationUsers.toDirectoryUser((ApplicationUser)((ApplicationUser)context.get("user")));
        Project project = (Project)context.get("project");
        Version version = (Version)context.get("version");
        String baseLinkUrl = this.getBaseLinkUrl(project, version);
        String queryString = "versionId=" + version.getId();
        this.bambooReleaseService.resetReleaseStateIfVersionWasUnreleased(version);
        HashMap<String, Object> velocityParams = new HashMap<String, Object>(context);
        velocityParams.put("req", ExecutingHttpRequest.get());
        velocityParams.put("soyRenderer", this.soyTemplateRenderer);
        velocityParams.putAll(this.bambooPanelHelper.getReleaseButtonParams(ApplicationUsers.from((User)user), version, project));
        this.bambooPanelHelper.prepareVelocityContext(velocityParams, MODULE_KEY, baseLinkUrl, queryString, project);
        return velocityParams;
    }

    private String getBaseLinkUrl(Project project, Version version) {
        return "/browse/" + project.getKey() + "/fixforversion/" + version.getId();
    }
}

