/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.manager;

import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.LegacyBambooServer;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.LegacyBambooServerImpl;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.manager.BambooStringEncrypter;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.manager.LegacyBambooServerManager;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.util.LegacyBambooPropertyManager;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.util.LegacyBambooServerIdGenerator;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LegacyBambooServerManagerImpl
implements LegacyBambooServerManager {
    public static final String CFG_ROOT = "bamboo.config";
    public static final String CFG_VERSION_NUMBER = "bamboo.config.version";
    public static final String CFG_SERVER_DEFS = "bamboo.config.server.definitions";
    public static final String CFG_SERVER_DEFAULT = "bamboo.config.server.default";
    public static final String CFG_KEY_ID = "id";
    public static final String CFG_KEY_NAME = "serverName";
    public static final String CFG_KEY_DESCRIPTION = "description";
    public static final String CFG_KEY_USERNAME = "username";
    public static final String CFG_KEY_PASSWORD = "password";
    public static final String CFG_KEY_HOST = "host";
    public static final String CFG_KEY_PROJECTS = "projects";
    public static final int CFG_VERSION_22 = 22;
    private static final String PROJECT_KEYS_SEPARATOR = " ,;:";
    private final Map<Integer, LegacyBambooServer> servers = new HashMap<Integer, LegacyBambooServer>();
    private final Map<String, Integer> projectMapping = new HashMap<String, Integer>();
    private LegacyBambooServer defaultServer;
    private final PropertySet propertySet;
    private final LegacyBambooServerIdGenerator idGenerator;
    private final LazyReference<BambooStringEncrypter> stringEncrypter = new LazyReference<BambooStringEncrypter>(){

        protected BambooStringEncrypter create() {
            return new BambooStringEncrypter();
        }
    };

    @Autowired
    public LegacyBambooServerManagerImpl(LegacyBambooPropertyManager propertyManager, LegacyBambooServerIdGenerator bambooServerIdGenerator) {
        this.idGenerator = (LegacyBambooServerIdGenerator)Preconditions.checkNotNull((Object)bambooServerIdGenerator);
        this.propertySet = propertyManager.getPropertySet();
        this.checkUpgradeConfig();
        this.loadAllServers();
        this.initDefaultServer();
    }

    private void initDefaultServer() {
        LegacyBambooServer cfgDefaultServer;
        int defaultServerId = 0;
        if (this.propertySet.exists(CFG_SERVER_DEFAULT)) {
            defaultServerId = this.propertySet.getInt(CFG_SERVER_DEFAULT);
        }
        if (defaultServerId != 0 && (cfgDefaultServer = this.getServer(defaultServerId)) != null) {
            this.setDefaultServer(cfgDefaultServer);
        }
        if (this.defaultServer == null) {
            this.pickDefaultServer();
        }
    }

    @Override
    public boolean isDefaultServer(LegacyBambooServer server) {
        if (null == server) {
            throw new IllegalArgumentException("Server must not be null.");
        }
        if (this.defaultServer == null) {
            this.pickDefaultServer();
        }
        return this.defaultServer != null && this.defaultServer.getId() == server.getId();
    }

    private void setDefaultServer(LegacyBambooServer server) {
        if (null == server) {
            throw new IllegalArgumentException("Cannot set default server to null.");
        }
        if (!this.servers.containsValue(server)) {
            throw new IllegalArgumentException("Default server must be a known server");
        }
        this.defaultServer = server;
        this.propertySet.setInt(CFG_SERVER_DEFAULT, server.getId());
    }

    private Collection<String> getServerConfPaths() {
        HashSet<String> serverNames = new HashSet<String>();
        Collection keys = this.propertySet.getKeys(CFG_SERVER_DEFS);
        for (String key : keys) {
            serverNames.add("bamboo.config.server.definitions." + StringUtils.substringBetween((String)key, (String)"bamboo.config.server.definitions.", (String)"."));
        }
        return serverNames;
    }

    @Override
    public Iterable<LegacyBambooServer> getServers() {
        return ImmutableList.copyOf(this.servers.values());
    }

    @Override
    public boolean hasServers() {
        return !this.servers.isEmpty();
    }

    private LegacyBambooServer getServer(int serverId) {
        return this.servers.get(serverId);
    }

    private void addServer(LegacyBambooServer server) {
        LegacyBambooServerImpl newServer = new LegacyBambooServerImpl(server);
        if (newServer.getId() == 0) {
            newServer.setId(this.idGenerator.next());
        }
        this.removeOldKeys(newServer);
        for (String projectKey : newServer.getAssociatedProjectKeys()) {
            Integer bambooServerId = this.projectMapping.get(projectKey);
            if (bambooServerId != null) {
                LegacyBambooServer conflictingServer = this.getServer(bambooServerId);
                if (conflictingServer != null && conflictingServer instanceof LegacyBambooServerImpl) {
                    ((LegacyBambooServerImpl)conflictingServer).removeAssociatedProjectKey(projectKey);
                }
                this.projectMapping.remove(projectKey);
            }
            this.projectMapping.put(projectKey, newServer.getId());
        }
        this.servers.put(newServer.getId(), newServer);
        if (this.defaultServer != null && newServer.getId() == this.defaultServer.getId()) {
            this.defaultServer = newServer;
        }
        this.store(newServer);
        if (this.defaultServer == null) {
            this.setDefaultServer(newServer);
        }
    }

    private void removeOldKeys(LegacyBambooServerImpl server) {
        HashSet<String> removables = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : this.projectMapping.entrySet()) {
            Integer value = entry.getValue();
            if (value == null || server.getId() != value.intValue() || server.getAssociatedProjectKeys().contains(entry.getKey())) continue;
            removables.add(entry.getKey());
        }
        for (String s : removables) {
            this.projectMapping.remove(s);
        }
    }

    private void pickDefaultServer() {
        if (this.servers.isEmpty()) {
            this.defaultServer = null;
            if (this.propertySet.exists(CFG_SERVER_DEFAULT)) {
                this.propertySet.remove(CFG_SERVER_DEFAULT);
            }
        } else {
            this.setDefaultServer(this.servers.values().iterator().next());
        }
    }

    private void upgradeConfigToVersion22() {
        LegacyBambooServerImpl server = this.load(CFG_ROOT);
        if (server.getName() != null) {
            server.setId(this.idGenerator.next());
            this.store(server);
            this.propertySet.setInt(CFG_SERVER_DEFAULT, server.getId());
            this.propertySet.remove("bamboo.config.serverName");
            this.propertySet.remove("bamboo.config.host");
        }
        this.propertySet.setInt(CFG_VERSION_NUMBER, 22);
    }

    private void checkUpgradeConfig() {
        int configVersionNumber = this.getConfigVersionNumber();
        if (configVersionNumber < 22) {
            this.upgradeConfigToVersion22();
            this.checkUpgradeConfig();
        }
    }

    private int getConfigVersionNumber() {
        int result = 0;
        if (this.propertySet.exists(CFG_VERSION_NUMBER)) {
            result = this.propertySet.getInt(CFG_VERSION_NUMBER);
        }
        return result;
    }

    private void loadAllServers() {
        Collection<String> keys = this.getServerConfPaths();
        for (String serverConfPath : keys) {
            LegacyBambooServerImpl server = this.load(serverConfPath);
            this.addServer(server);
        }
    }

    private LegacyBambooServerImpl load(String configurationPath) {
        LegacyBambooServerImpl server = new LegacyBambooServerImpl();
        server.setHost(this.propertySet.getString(configurationPath + "." + CFG_KEY_HOST));
        server.setId(this.propertySet.getInt(configurationPath + "." + CFG_KEY_ID));
        server.setName(this.propertySet.getString(configurationPath + "." + CFG_KEY_NAME));
        server.setDescription(this.propertySet.getString(configurationPath + "." + CFG_KEY_DESCRIPTION));
        server.setUsername(this.propertySet.getString(configurationPath + "." + CFG_KEY_USERNAME));
        server.setPassword(((BambooStringEncrypter)this.stringEncrypter.get()).decrypt(this.propertySet.getString(configurationPath + "." + CFG_KEY_PASSWORD)));
        String[] projectKeys = StringUtils.split((String)this.propertySet.getString(configurationPath + "." + CFG_KEY_PROJECTS), (String)PROJECT_KEYS_SEPARATOR);
        if (projectKeys != null) {
            server.setAssociatedProjectKeys(new HashSet<String>(Arrays.asList(projectKeys)));
        }
        return server;
    }

    private void store(LegacyBambooServer server) {
        this.store(server, "bamboo.config.server.definitions." + String.valueOf(server.getId()));
    }

    private void store(LegacyBambooServer server, String configurationPath) {
        this.propertySet.setInt(configurationPath + "." + CFG_KEY_ID, server.getId());
        this.propertySet.setString(configurationPath + "." + CFG_KEY_NAME, server.getName());
        this.propertySet.setString(configurationPath + "." + CFG_KEY_DESCRIPTION, server.getDescription());
        this.propertySet.setString(configurationPath + "." + CFG_KEY_HOST, server.getHost());
        this.propertySet.setString(configurationPath + "." + CFG_KEY_USERNAME, server.getUsername());
        this.propertySet.setString(configurationPath + "." + CFG_KEY_PASSWORD, ((BambooStringEncrypter)this.stringEncrypter.get()).encrypt(server.getPassword()));
        Object[] projects = server.getAssociatedProjectKeys().toArray();
        Arrays.sort(projects);
        this.propertySet.setString(configurationPath + "." + CFG_KEY_PROJECTS, StringUtils.join((Object[])projects, (char)' '));
    }
}

