/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.upgrade;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.LegacyBambooServer;
import com.atlassian.jira.plugin.ext.bamboo.upgrade.legacy.manager.LegacyBambooServerManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={PluginUpgradeTask.class})
@Component
public class ApplicationLinkMigrationUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = Logger.getLogger(ApplicationLinkMigrationUpgradeTask.class);
    private final MutatingApplicationLinkService mutatingLinkService;
    private final LegacyBambooServerManager legacyServerManager;
    private final BambooApplicationLinkManager applinkManager;
    private final TypeAccessor typeAccessor;
    private final AuthenticationConfigurationManager authConfigManager;

    @Autowired
    public ApplicationLinkMigrationUpgradeTask(@ComponentImport AuthenticationConfigurationManager authConfigManager, @ComponentImport MutatingApplicationLinkService mutatingLinkService, @ComponentImport TypeAccessor typeAccessor, BambooApplicationLinkManager applinkManager, LegacyBambooServerManager legacyServerManager) {
        this.applinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)applinkManager);
        this.authConfigManager = (AuthenticationConfigurationManager)Preconditions.checkNotNull((Object)authConfigManager);
        this.legacyServerManager = (LegacyBambooServerManager)Preconditions.checkNotNull((Object)legacyServerManager);
        this.mutatingLinkService = (MutatingApplicationLinkService)Preconditions.checkNotNull((Object)mutatingLinkService);
        this.typeAccessor = (TypeAccessor)Preconditions.checkNotNull((Object)typeAccessor);
    }

    public Collection<Message> doUpgrade() throws Exception {
        for (LegacyBambooServer server : this.legacyServerManager.getServers()) {
            URI hostURI = URI.create(server.getHost());
            if (this.isApplicationLinkPreexisting(hostURI)) continue;
            ApplicationId id = ApplicationIdUtil.generate((URI)hostURI);
            ApplicationLinkDetails details = ApplicationLinkDetails.builder().name(server.getName()).displayUrl(hostURI).rpcUrl(hostURI).isPrimary(this.legacyServerManager.isDefaultServer(server)).build();
            log.info((Object)("Creating Bamboo application link for: " + server.getHost()));
            this.mutatingLinkService.addApplicationLink(id, this.getBambooType(), details);
            ImmutableMap authParams = ImmutableMap.builder().put((Object)"username", (Object)server.getUsername()).put((Object)"password", (Object)(server.getPassword() == null ? "" : server.getPassword())).build();
            this.authConfigManager.registerProvider(id, BasicAuthenticationProvider.class, (Map)authParams);
            if (server.getAssociatedProjectKeys().isEmpty()) continue;
            for (String projectKey : server.getAssociatedProjectKeys()) {
                log.info((Object)("Creating Bamboo application link for: " + server.getHost()));
                this.applinkManager.associate(projectKey, id);
            }
        }
        return null;
    }

    private boolean isApplicationLinkPreexisting(URI hostURI) {
        for (ApplicationLink applink : this.applinkManager.getApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED)) {
            if (!applink.getDisplayUrl().equals(hostURI)) continue;
            return true;
        }
        return false;
    }

    private ApplicationType getBambooType() {
        return (ApplicationType)Preconditions.checkNotNull((Object)this.typeAccessor.getApplicationType(BambooApplicationType.class), (Object)"BambooApplicationType not installed");
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Legacy Application Link Upgrade";
    }

    public String getPluginKey() {
        return "com.atlassian.jira.plugin.ext.bamboo";
    }
}

