/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.jira.plugin.ext.bamboo.service.ReleaseErrorReportingService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleaseErrorReportingServiceImpl
implements ReleaseErrorReportingService {
    private static final Logger log = Logger.getLogger(ReleaseErrorReportingServiceImpl.class);
    private final Function<String, ManagedLock.ReadWrite> lockManager = ManagedLocks.weakReadWriteManagedLockFactory();
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    public ReleaseErrorReportingServiceImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory);
    }

    @Override
    public void recordError(final @Nonnull String projectKey, final long versionId, final @Nonnull String error) {
        ((ManagedLock.ReadWrite)this.lockManager.get((Object)(projectKey + versionId))).write().withLock(new Runnable(){

            @Override
            public void run() {
                List<String> errors = new ArrayList<String>();
                PluginSettings settingsForKey = ReleaseErrorReportingServiceImpl.this.pluginSettingsFactory.createSettingsForKey(projectKey);
                Object errorObject = settingsForKey.get("bamboo.release.errors." + versionId);
                if (errorObject != null && List.class.isAssignableFrom(errorObject.getClass())) {
                    errors = (List)errorObject;
                }
                errors.add(error);
                settingsForKey.put("bamboo.release.errors." + versionId, errors);
            }
        });
    }

    @Override
    public void recordErrors(final @Nonnull String projectKey, final long versionId, final @Nonnull List<String> errors) {
        if (!errors.isEmpty()) {
            ((ManagedLock.ReadWrite)this.lockManager.get((Object)(projectKey + versionId))).write().withLock(new Runnable(){

                @Override
                public void run() {
                    for (String error : errors) {
                        ReleaseErrorReportingServiceImpl.this.recordError(projectKey, versionId, error);
                    }
                }
            });
        }
    }

    @Override
    @Nonnull
    public List<String> getErrors(final @Nonnull String projectKey, final long versionId) {
        try {
            return (List)((ManagedLock.ReadWrite)this.lockManager.get((Object)(projectKey + versionId))).read().withLock((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    PluginSettings settingsForKey = ReleaseErrorReportingServiceImpl.this.pluginSettingsFactory.createSettingsForKey(projectKey);
                    Object errorObject = settingsForKey.get("bamboo.release.errors." + versionId);
                    if (errorObject != null && List.class.isAssignableFrom(errorObject.getClass())) {
                        return (List)errorObject;
                    }
                    return Collections.emptyList();
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"An unexpected error has occurred", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void clearErrors(final @Nonnull String projectKey, final long versionId) {
        ((ManagedLock.ReadWrite)this.lockManager.get((Object)(projectKey + versionId))).write().withLock(new Runnable(){

            @Override
            public void run() {
                PluginSettings settingsForKey = ReleaseErrorReportingServiceImpl.this.pluginSettingsFactory.createSettingsForKey(projectKey);
                settingsForKey.remove("bamboo.release.errors." + versionId);
            }
        });
    }
}

