/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.ext.bamboo.service.ProjectVersionService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectVersionServiceImpl
implements ProjectVersionService {
    @VisibleForTesting
    static final PagerFilter UNLIMITED_FILTER = PagerFilter.getUnlimitedFilter();
    @VisibleForTesting
    static final String ADMIN_ERROR_KEY = "admin.errors.project.exception";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectVersionService.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchProvider searchProvider;

    @Autowired
    public ProjectVersionServiceImpl(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport SearchProvider searchProvider) {
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.searchProvider = (SearchProvider)Preconditions.checkNotNull((Object)searchProvider);
    }

    @Override
    @Nonnull
    public Either<String, Integer> getUnresolvedIssueCount(long projectId, long versionId) {
        try {
            Query query = JqlQueryBuilder.newBuilder().where().project(new Long[]{projectId}).and().unresolved().and().fixVersion(Long.valueOf(versionId)).buildQuery();
            SearchResults results = this.searchProvider.search(query, this.jiraAuthenticationContext.getLoggedInUser(), UNLIMITED_FILTER);
            return Either.right((Object)results.getTotal());
        }
        catch (Exception e) {
            LOGGER.error("Exception whilst getting unresolved issues " + e.getMessage(), (Throwable)e);
            return Either.left((Object)this.jiraAuthenticationContext.getI18nHelper().getText(ADMIN_ERROR_KEY, (Object)e));
        }
    }
}

