/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.LifeCycleState;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.jira.plugin.ext.bamboo.service.ImpersonationService;
import com.atlassian.jira.plugin.ext.bamboo.service.PlanResultStatusUpdateService;
import com.atlassian.jira.plugin.ext.bamboo.service.PlanStatusUpdateJob;
import com.atlassian.jira.plugin.ext.bamboo.service.ReleaseErrorReportingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={PlanResultStatusUpdateService.class, LifecycleAware.class})
@Component
public class PlanStatusUpdateServiceImpl
implements PlanResultStatusUpdateService,
LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PlanStatusUpdateServiceImpl.class);
    private static final long DEFAULT_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private static final String BAMBOO_STATUS_UPDATE_INTERVAL = "bamboo.status.update.interval";
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"Bamboo Status Update"));
    private final ConcurrentMap<PlanResultKey, Subscription> planResultKeyToSubscriptionMap = new MapMaker().makeMap();
    private final ConcurrentMap<Subscription, Future<?>> subscriptionFutureMap = new MapMaker().makeMap();
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooRestService bambooRestService;
    private final EventPublisher eventPublisher;
    private final ImpersonationService impersonationService;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final ReleaseErrorReportingService releaseErrorReportingService;
    private final SchedulerService schedulerService;

    @Autowired
    public PlanStatusUpdateServiceImpl(@ComponentImport EventPublisher eventPublisher, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ProjectManager projectManager, @ComponentImport SchedulerService schedulerService, BambooApplicationLinkManager bambooApplicationLinkManager, BambooRestService bambooRestService, ImpersonationService impersonationService, ReleaseErrorReportingService releaseErrorReportingService) {
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.impersonationService = (ImpersonationService)Preconditions.checkNotNull((Object)impersonationService);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
        this.releaseErrorReportingService = (ReleaseErrorReportingService)Preconditions.checkNotNull((Object)releaseErrorReportingService);
        this.schedulerService = (SchedulerService)Preconditions.checkNotNull((Object)schedulerService);
    }

    @Override
    public void subscribe(@Nonnull Version version, @Nonnull PlanResultKey planResultKey, @Nonnull String username, @Nonnull PlanResultStatusUpdateService.FinalizingAction finalizingAction) {
        Project project = version.getProject();
        log.info("Bamboo Release Plugin waiting for result for build '" + planResultKey + "' for project '" + project.getKey() + "' and version '" + version.getName() + "'");
        Subscription subscription = new Subscription(planResultKey, project.getKey(), version.getId(), username, finalizingAction);
        this.planResultKeyToSubscriptionMap.putIfAbsent(planResultKey, subscription);
        this.scheduleUpdate(subscription);
    }

    @Override
    public void unsubscribe(@Nonnull PlanResultKey planResultKey) {
        Subscription subscription = (Subscription)this.planResultKeyToSubscriptionMap.remove(planResultKey);
        if (subscription != null) {
            this.removeFuture(subscription);
        }
    }

    @Override
    public int scheduleUpdates() {
        int updatesScheduled = 0;
        for (Subscription subscription : this.planResultKeyToSubscriptionMap.values()) {
            if (this.subscriptionFutureMap.containsKey(subscription)) continue;
            this.scheduleUpdate(subscription);
            ++updatesScheduled;
            log.debug("Scheduled updating of {}", (Object)subscription);
        }
        return updatesScheduled;
    }

    public void onStart() {
        this.schedulerService.registerJobRunner(PlanStatusUpdateJob.KEY, (JobRunner)new PlanStatusUpdateJob(this));
        long intervalInMillis = this.getPlanStatusUpdateJobIntervalInMillis();
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)PlanStatusUpdateJob.KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)new Date()));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            log.info("{} scheduled to run every {} seconds", (Object)PlanStatusUpdateJob.class.getSimpleName(), (Object)TimeUnit.MILLISECONDS.toSeconds(intervalInMillis));
        }
        catch (SchedulerServiceException e) {
            log.error("Could not schedule plan status update job");
            throw new RuntimeException(e);
        }
    }

    private long getPlanStatusUpdateJobIntervalInMillis() {
        return Long.getLong(BAMBOO_STATUS_UPDATE_INTERVAL, DEFAULT_INTERVAL);
    }

    public void onStop() {
        this.schedulerService.unregisterJobRunner(PlanStatusUpdateJob.KEY);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onEvent(ClearCacheEvent event) {
        this.planResultKeyToSubscriptionMap.clear();
        this.subscriptionFutureMap.clear();
    }

    private void scheduleUpdate(@Nonnull Subscription subscription) {
        ApplicationLink applicationLink = subscription.getApplicationLink();
        if (applicationLink == null) {
            this.applicationLinkUnavailable(subscription);
        } else {
            log.info("Scheduling update from '" + applicationLink + "' for Plan '" + subscription.planResultKey + "'");
            Future<?> planStatusFuture = this.threadPoolExecutor.submit(subscription.planStatusRunnable);
            this.subscriptionFutureMap.putIfAbsent(subscription, planStatusFuture);
        }
    }

    private void applicationLinkUnavailable(@Nonnull Subscription subscription) {
        this.releaseErrorReportingService.recordError(subscription.projectKey, subscription.versionId, this.getI18nHelper().getText("bamboo.error.connectivity", "Bamboo"));
        this.unsubscribe(subscription.planResultKey);
        log.error("ApplicationLink failure - Could not connect to Plan '" + subscription.planResultKey.getPlanKey() + "' for Project '" + subscription.projectKey + "'");
    }

    private void removeFuture(Subscription subscription) {
        this.subscriptionFutureMap.remove(subscription);
    }

    private I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }

    private final class UpdatePlanStatus
    implements Runnable {
        private final Subscription subscription;

        private UpdatePlanStatus(Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public void run() {
            ApplicationLink applicationLink = this.subscription.getApplicationLink();
            if (applicationLink != null) {
                ApplicationLinkRequestFactory authenticatedRequestFactory = applicationLink.createAuthenticatedRequestFactory();
                if (authenticatedRequestFactory != null) {
                    try {
                        RestResult<PlanResultStatus> restResult = PlanStatusUpdateServiceImpl.this.bambooRestService.getPlanResultStatus(authenticatedRequestFactory, this.subscription.planResultKey);
                        PlanResultStatus planStatus = restResult.getResult();
                        if (!restResult.getErrors().isEmpty()) {
                            PlanStatusUpdateServiceImpl.this.releaseErrorReportingService.recordError(this.subscription.projectKey, this.subscription.versionId, PlanStatusUpdateServiceImpl.this.getI18nHelper().getText("bamboo.error.connectivity", applicationLink.getName()));
                        }
                        if (planStatus != null) {
                            this.runFinalizingAction(planStatus, this.subscription);
                        }
                    }
                    catch (CredentialsRequiredException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Authorisation Required", (Throwable)e);
                        }
                        log.info("JIRA could not connect to the Bamboo instance '" + applicationLink.getName() + "' to complete the release. This may require user authentication");
                    }
                } else {
                    PlanStatusUpdateServiceImpl.this.applicationLinkUnavailable(this.subscription);
                }
            } else {
                PlanStatusUpdateServiceImpl.this.applicationLinkUnavailable(this.subscription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runFinalizingAction(@Nonnull PlanResultStatus status, @Nonnull Subscription subscription) {
            PlanResultKey planResultKey = subscription.planResultKey;
            ApplicationLink applicationLink = subscription.getApplicationLink();
            if (applicationLink == null) {
                PlanStatusUpdateServiceImpl.this.applicationLinkUnavailable(subscription);
            } else {
                log.info("Plan '" + status.getPlanResultKey() + "' BuildState: '" + (Object)((Object)status.getBuildState()) + "' LifeCycleState: '" + (Object)((Object)status.getLifeCycleState()) + "'");
                if (status.isValid() && LifeCycleState.isFinalized(status.getLifeCycleState())) {
                    log.info("Bamboo Release Plugin detected that " + planResultKey + " from " + applicationLink.getDisplayUrl() + " has finished.");
                    try {
                        subscription.finalizingAction.execute(status);
                    }
                    catch (Throwable e) {
                        log.error("Could not run action for subscription '" + planResultKey + "' for Bamboo Server '" + applicationLink + "'", e);
                    }
                    finally {
                        PlanStatusUpdateServiceImpl.this.unsubscribe(subscription.planResultKey);
                    }
                } else if (!status.isRecoverable()) {
                    PlanStatusUpdateServiceImpl.this.unsubscribe(subscription.planResultKey);
                    log.error("Status update reached an unrecoverable state for '" + planResultKey + "' from Bamboo Server '" + applicationLink + "'. JIRA will no longer update the status.");
                }
                log.info("Removing subscription to '" + applicationLink + "' for Plan '" + subscription.planResultKey + "'");
                PlanStatusUpdateServiceImpl.this.removeFuture(subscription);
            }
        }
    }

    private final class Subscription {
        private final long versionId;
        private final PlanResultStatusUpdateService.FinalizingAction finalizingAction;
        private final PlanResultKey planResultKey;
        private final Runnable planStatusRunnable;
        private final String projectKey;

        private Subscription(@Nonnull PlanResultKey planResultKey, String projectKey, @Nonnull long versionId, @Nonnull String username, PlanResultStatusUpdateService.FinalizingAction finalizingAction) {
            this.finalizingAction = finalizingAction;
            this.planResultKey = planResultKey;
            this.projectKey = projectKey;
            this.versionId = versionId;
            this.planStatusRunnable = PlanStatusUpdateServiceImpl.this.impersonationService.runAsUser(username, new UpdatePlanStatus(this));
        }

        @Nullable
        public ApplicationLink getApplicationLink() {
            Project project = PlanStatusUpdateServiceImpl.this.projectManager.getProjectObjByKey(this.projectKey);
            if (project != null) {
                return PlanStatusUpdateServiceImpl.this.bambooApplicationLinkManager.getApplicationLink(project.getKey());
            }
            log.error("Could not find project '" + this.projectKey + "'");
            return null;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

