/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.jira.plugin.ext.bamboo.service.PlanResultStatusUpdateService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlanStatusUpdateJob
implements JobRunner {
    public static final JobRunnerKey KEY = JobRunnerKey.of((String)PlanStatusUpdateJob.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanStatusUpdateJob.class);
    private final PlanResultStatusUpdateService planResultStatusUpdateService;

    public PlanStatusUpdateJob(PlanResultStatusUpdateService planResultStatusUpdateService) {
        this.planResultStatusUpdateService = (PlanResultStatusUpdateService)Preconditions.checkNotNull((Object)planResultStatusUpdateService);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        int updatesScheduled = this.planResultStatusUpdateService.scheduleUpdates();
        if (updatesScheduled > 0) {
            LOGGER.debug("Scheduled {} plan status update(s)", (Object)updatesScheduled);
        }
        return JobRunnerResponse.success();
    }
}

