/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.jira.plugin.ext.bamboo.service.ImpersonationService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.auth.AuthenticationContextImpl;
import java.security.Principal;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImpersonationServiceImpl
implements ImpersonationService {
    private final UserManager userManager;
    private final com.atlassian.sal.api.user.UserManager salUserManager;

    @Autowired
    public ImpersonationServiceImpl(@ComponentImport(value="jiraUserManager") UserManager userManager, @ComponentImport(value="salUserManager") com.atlassian.sal.api.user.UserManager salUserManager) {
        this.salUserManager = salUserManager;
        this.userManager = userManager;
    }

    @Override
    @Nonnull
    public Runnable runAsUser(@Nonnull String username, @Nonnull Runnable delegate) {
        return () -> {
            AuthenticationContextImpl authenticationContext = new AuthenticationContextImpl();
            Principal currentPrincipal = authenticationContext.getUser();
            try {
                String remoteUserName;
                ApplicationUser user = this.userManager.getUserByName(username);
                if (user == null) {
                    throw new IllegalStateException("username '" + username + "' does not exist. Cannot impersonate this user.");
                }
                authenticationContext.setUser((Principal)user);
                String string2 = remoteUserName = this.salUserManager.getRemoteUser() != null ? this.salUserManager.getRemoteUser().getUsername() : null;
                if (!username.equals(remoteUserName)) {
                    throw new IllegalStateException("Could not impersonate user '" + username + "'. Call to '" + this.salUserManager.getClass() + ".getRemoteUsername()' returns '" + remoteUserName + "'");
                }
                delegate.run();
            }
            finally {
                authenticationContext.setUser(currentPrincipal);
            }
        };
    }
}

