/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooContentRewriter;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooServerAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BambooServerAccessorImpl
implements BambooServerAccessor {
    public static final String NO_CHECK = "no-check";
    public static final String X_ATLASSIAN_TOKEN = "X-Atlassian-Token";
    @VisibleForTesting
    static final String BUILD_RESULT_INDICATOR = "build_result";
    @VisibleForTesting
    static final String ISSUE_KEY_PARAM = "jiraIssueKey";
    @VisibleForTesting
    static final String LOGIN_FORM_INDICATOR = "loginForm";
    @VisibleForTesting
    static final String NO_ASSOCIATED_BUILDS_I18N_KEY = "bamboo.tabpanel.no.associated.builds";
    @VisibleForTesting
    static final String NO_BAMBOO_APPLICATION_LINK_MESSAGE = "No Bamboo application link configured.";
    @VisibleForTesting
    static final String PROJECT_KEY_PARAM = "projectKey";
    @VisibleForTesting
    static final String[] DEFAULT_REQUEST_PARAMS = new String[]{"enableJavascript", "false", "maxBuilds", "25"};
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooContentRewriter bambooContentRewriter;
    private final I18nHelper i18nHelper;
    private final ProjectManager projectManager;

    @Autowired
    public BambooServerAccessorImpl(@ComponentImport I18nHelper i18nHelper, @ComponentImport ProjectManager projectManager, BambooApplicationLinkManager bambooApplicationLinkManager, BambooContentRewriter bambooContentRewriter) {
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooContentRewriter = (BambooContentRewriter)Preconditions.checkNotNull((Object)bambooContentRewriter);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
    }

    @Override
    public String getHtmlFromAction(String bambooAction, Project project, Map<String, String> extraParams) throws IOException, ResponseException, CredentialsRequiredException {
        LinkedHashSet allProjectKeys = Sets.newLinkedHashSet();
        allProjectKeys.add(project.getKey());
        allProjectKeys.addAll(this.projectManager.getAllProjectKeys(project.getId()));
        ApplicationLink applicationLink = this.bambooApplicationLinkManager.getApplicationLink(project.getKey());
        StringBuilder sb = new StringBuilder();
        for (String key : allProjectKeys) {
            String result;
            ArrayListMultimap params = ArrayListMultimap.create();
            params.put((Object)PROJECT_KEY_PARAM, (Object)key);
            if (extraParams != null) {
                params.putAll((Multimap)Multimaps.forMap(extraParams));
            }
            if (!StringUtils.contains((CharSequence)(result = this.getHtmlFromUrl(applicationLink, bambooAction, (Multimap<String, String>)params)), (CharSequence)BUILD_RESULT_INDICATOR)) continue;
            sb.append(result);
        }
        if (sb.length() == 0) {
            sb.append("<p>");
            sb.append(this.i18nHelper.getText(NO_ASSOCIATED_BUILDS_I18N_KEY));
            sb.append("</p>");
        }
        return sb.toString();
    }

    @Override
    public String getHtmlFromAction(String bambooAction, Project project, Iterable<String> issueKeys, Map<String, String> extraParams) throws IOException, ResponseException, CredentialsRequiredException {
        ArrayListMultimap params = ArrayListMultimap.create();
        ApplicationLink applicationLink = this.bambooApplicationLinkManager.getApplicationLink(project.getKey());
        if (applicationLink == null) {
            return NO_BAMBOO_APPLICATION_LINK_MESSAGE;
        }
        for (String issueKey : issueKeys) {
            params.put((Object)ISSUE_KEY_PARAM, (Object)issueKey);
        }
        if (extraParams != null) {
            params.putAll((Multimap)Multimaps.forMap(extraParams));
        }
        return this.getHtmlFromUrl(applicationLink, bambooAction, (Multimap<String, String>)params);
    }

    private String getHtmlFromUrl(ApplicationLink applicationLink, String bambooAction, Multimap<String, String> params) throws IOException, CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.POST, bambooAction);
        request.addRequestParameters(DEFAULT_REQUEST_PARAMS);
        for (String param : params.keySet()) {
            for (String value : params.get((Object)param)) {
                request.addRequestParameters(new String[]{param, value});
            }
        }
        request.setSoTimeout(50000);
        request.setConnectionTimeout(50000);
        request.setHeader(X_ATLASSIAN_TOKEN, NO_CHECK);
        String responseHtml = request.execute();
        if (responseHtml.contains(LOGIN_FORM_INDICATOR)) {
            throw new ResponseException("Using applinks but got login form -> Authentication configuration problem.");
        }
        return this.bambooContentRewriter.rewriteHtml(responseHtml, applicationLink.getDisplayUrl().toASCIIString());
    }
}

