/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.ext.bamboo.model.BambooDeploymentProject;
import com.atlassian.jira.plugin.ext.bamboo.model.BambooEnvironment;
import com.atlassian.jira.plugin.ext.bamboo.model.BambooPlan;
import com.atlassian.jira.plugin.ext.bamboo.model.BambooProject;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.server.BambooServerInfo;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestResponse;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={BambooRestService.class})
@Component
public class BambooRestServiceImpl
implements BambooRestService {
    private static final Logger log = Logger.getLogger(BambooRestServiceImpl.class);
    public static final int TRIGGER_CALL_TIMEOUT = 50000;
    public static final String X_ATLASSIAN_TOKEN = "X-Atlassian-Token";
    public static final String NO_CHECK = "no-check";
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public BambooRestServiceImpl(@ComponentImport JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
    }

    @Override
    @Nonnull
    public RestResult<Map<BambooProject, List<BambooPlan>>> getPlanList(@Nonnull ApplicationLink applicationLink, boolean includeDisabled) throws CredentialsRequiredException {
        String plansUrl = "/rest/api/latest/project.json?expand=projects.project.plans&withBuildPermissionOnly&max-results=10000";
        BambooRestResponse response = this.executeGetRequest(applicationLink, "/rest/api/latest/project.json?expand=projects.project.plans&withBuildPermissionOnly&max-results=10000", 50000);
        HashSet<String> errorCollection = new HashSet<String>();
        TreeMap projectPlansMap = new TreeMap();
        try {
            JSONObject result = this.parseResponseForJsonObject(applicationLink.getName(), response, errorCollection);
            if (result != null) {
                JSONArray projectArray = result.getJSONObject("projects").getJSONArray("project");
                for (int i = 0; i < projectArray.length(); ++i) {
                    JSONObject projectObject = projectArray.getJSONObject(i);
                    String projectName = projectObject.getString("name");
                    String projectKey = projectObject.getString("key");
                    BambooProject project = new BambooProject(projectKey, projectName);
                    ArrayList<BambooPlan> plans = new ArrayList<BambooPlan>();
                    JSONArray planArray = projectObject.getJSONObject("plans").getJSONArray("plan");
                    for (int j = 0; j < planArray.length(); ++j) {
                        JSONObject planObject = planArray.getJSONObject(j);
                        String planName = planObject.getString("name");
                        String shortName = planObject.getString("shortName");
                        String planKey = planObject.getString("key");
                        boolean enabled = planObject.getBoolean("enabled");
                        if (!enabled && !includeDisabled) continue;
                        plans.add(new BambooPlan(planKey, planName, shortName));
                    }
                    Collections.sort(plans);
                    if (plans.isEmpty()) continue;
                    projectPlansMap.put(project, plans);
                }
            }
        }
        catch (JSONException e) {
            log.error((Object)"Failed to parse Bamboo plan list", (Throwable)e);
            errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", applicationLink.getName()));
        }
        return new RestResult<Map<BambooProject, List<BambooPlan>>>(projectPlansMap, errorCollection, response.getStatusCode());
    }

    @Override
    @Nonnull
    public RestResult<PlanResultStatus> getPlanResultStatus(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory, @Nonnull PlanResultKey planResultKey) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/result/" + planResultKey.getPlanKey().getKey() + "/" + planResultKey.getBuildNumber() + ".json";
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, resultUrl, 50000, "Bamboo");
        HashSet<String> errorCollection = new HashSet<String>();
        try {
            JSONObject result = this.parseResponseForJsonObject("Bamboo", response, errorCollection);
            if (result != null) {
                return new RestResult<PlanResultStatus>(PlanResultStatus.fromJsonObject(planResultKey, result), errorCollection, response.getStatusCode());
            }
        }
        catch (JSONException e) {
            log.error((Object)"Failed to parse Bamboo result status", (Throwable)e);
            errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", "Bamboo"));
        }
        PlanResultStatus planResultStatus = new PlanResultStatus(planResultKey, null, null, false);
        return new RestResult<PlanResultStatus>(planResultStatus, errorCollection, response.getStatusCode());
    }

    @Override
    @Nonnull
    public RestResult<PlanStatus> getPlanStatus(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory, @Nonnull PlanKey planKey) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/result/" + planKey.getKey() + ".json?max-results=1";
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, resultUrl, 50000, "Bamboo");
        HashSet<String> errorCollection = new HashSet<String>();
        try {
            JSONObject results = this.parseResponseForJsonObject("Bamboo", response, errorCollection);
            if (results != null) {
                JSONArray resultsArray = results.getJSONObject("results").getJSONArray("result");
                if (resultsArray.isNull(0)) {
                    return new RestResult<PlanStatus>(new PlanStatus(planKey, null, null), errorCollection, response.getStatusCode());
                }
                JSONObject latestResult = resultsArray.getJSONObject(0);
                return new RestResult<PlanStatus>(PlanStatus.fromJsonObject(planKey, latestResult), errorCollection, response.getStatusCode());
            }
        }
        catch (JSONException e) {
            log.error((Object)("Failed to parse Bamboo latest result status for Plan " + planKey + ": "), (Throwable)e);
            errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", "Bamboo"));
        }
        return new RestResult<Object>(null, errorCollection, response.getStatusCode());
    }

    @Override
    @Nonnull
    public RestResult<JSONObject> getPlanResultJson(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory, @Nonnull PlanResultKey planResultKey) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/result/" + planResultKey.getPlanKey().getKey() + "/" + planResultKey.getBuildNumber() + ".json?expand=artifacts.artifact,labels.label";
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, resultUrl, 50000, "Bamboo");
        HashSet errorCollection = Sets.newHashSet();
        JSONObject jsonObject = this.parseResponseForJsonObject("Bamboo", response, errorCollection);
        return new RestResult<JSONObject>(jsonObject, errorCollection, response.getStatusCode());
    }

    @Override
    @Nonnull
    public RestResult<JSONObject> getPlanJson(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory, @Nonnull PlanKey planKey) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/plan/" + planKey + ".json?expand=stages,variableContext";
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, resultUrl, 50000, "Bamboo");
        HashSet errorCollection = Sets.newHashSet();
        JSONObject jsonObject = this.parseResponseForJsonObject("Bamboo", response, errorCollection);
        return new RestResult<JSONObject>(jsonObject, errorCollection, response.getStatusCode());
    }

    @Override
    public RestResult<JSONObject> getPlanHistory(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory, @Nonnull PlanKey planKey, int numberOfResults, @Nonnull Map<String, String> urlParams) throws CredentialsRequiredException {
        if (numberOfResults < 0) {
            throw new IllegalArgumentException("Cannot request zero or negative number of results");
        }
        StringBuilder resultUrl = new StringBuilder("/rest/api/latest/result/" + planKey + ".json?expand=results.result.stages&max-results=" + numberOfResults);
        for (Map.Entry<String, String> entry : urlParams.entrySet()) {
            resultUrl.append('&').append(entry.getKey()).append('=').append(entry.getValue());
        }
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, resultUrl.toString(), 50000, "Bamboo");
        HashSet errorCollection = Sets.newHashSet();
        JSONObject jsonObject = this.parseResponseForJsonObject("Bamboo", response, errorCollection);
        return new RestResult<JSONObject>(jsonObject, errorCollection, response.getStatusCode());
    }

    @Override
    @Nonnull
    public RestResult<PlanResultKey> triggerPlan(@Nonnull ApplicationLink applicationLink, @Nonnull PlanKey planKey, @Nullable String stage, @Nonnull Map<String, String> params) throws CredentialsRequiredException {
        return this.executeTrigger(applicationLink, planKey.getKey(), stage, params, TriggerType.NEW);
    }

    @Override
    @Nonnull
    public RestResult<PlanResultKey> continuePlan(@Nonnull ApplicationLink applicationLink, @Nonnull PlanResultKey planResultKey, @Nullable String stage, @Nonnull Map<String, String> params) throws CredentialsRequiredException {
        return this.executeTrigger(applicationLink, planResultKey.getKey(), stage, params, TriggerType.EXISTING);
    }

    @Override
    public RestResult<JSONObject> getDeploymentProjectsForIssue(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory, @Nonnull String serverName, @Nonnull String issueKey) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/deploy/issue-status/" + issueKey;
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, resultUrl, 50000, serverName);
        HashSet<String> errorCollection = new HashSet<String>();
        JSONObject jsonObject = this.parseResponseForJsonObject(serverName, response, errorCollection, false);
        return new RestResult<JSONObject>(jsonObject, errorCollection, response.getStatusCode());
    }

    @Override
    public RestResult<JSONObject> getIssueDeploymentStatus(@Nonnull ApplicationLink applicationLink, @Nonnull String issueKey, @Nonnull String deploymentProjectId) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/deploy/issue-status/" + issueKey + "/" + deploymentProjectId;
        BambooRestResponse response = this.executeGetRequest(applicationLink.createAuthenticatedRequestFactory(), resultUrl, 50000, "Bamboo");
        HashSet<String> errorCollection = new HashSet<String>();
        JSONObject jsonObject = this.parseResponseForJsonObject(applicationLink.getName(), response, errorCollection, false);
        return new RestResult<JSONObject>(jsonObject, errorCollection, response.getStatusCode());
    }

    @Override
    public RestResult<BambooServerInfo> getBambooServerInfo(@Nonnull ApplicationLinkRequestFactory applicationLinkRequestFactory) throws CredentialsRequiredException {
        String resultUrl = "/rest/api/latest/info.json";
        BambooRestResponse response = this.executeGetRequest(applicationLinkRequestFactory, "/rest/api/latest/info.json", 50000, "Bamboo");
        HashSet errorCollection = Sets.newHashSet();
        JSONObject jsonObject = this.parseResponseForJsonObject("Bamboo", response, errorCollection);
        return new RestResult<BambooServerInfo>(BambooServerInfo.fromJSON(jsonObject, errorCollection), errorCollection, response.getStatusCode());
    }

    @Override
    @Nonnull
    public RestResult<Map<BambooDeploymentProject, List<BambooEnvironment>>> getEnvironmentList(@Nonnull ApplicationLink applicationLink) throws CredentialsRequiredException {
        String restUrl = "/rest/api/latest/deploy/project/all.json";
        BambooRestResponse response = this.executeGetRequest(applicationLink, "/rest/api/latest/deploy/project/all.json", 50000);
        HashSet<String> errorCollection = new HashSet<String>();
        TreeMap projectEnvironmentsMap = Maps.newTreeMap();
        try {
            JSONArray deploymentProjects = this.parseResponseForJsonArray(applicationLink.getName(), response, errorCollection, true);
            if (deploymentProjects != null) {
                for (int i = 0; i < deploymentProjects.length(); ++i) {
                    JSONObject projectObject = deploymentProjects.getJSONObject(i);
                    BambooDeploymentProject deploymentProject = this.parseBambooDeploymentProject(projectObject);
                    ArrayList environments = Lists.newArrayList();
                    JSONArray environmentArray = projectObject.getJSONArray("environments");
                    for (int j = 0; j < environmentArray.length(); ++j) {
                        JSONObject environmentObject = environmentArray.getJSONObject(j);
                        BambooEnvironment environment = this.parseBambooEnvironment(environmentObject);
                        environments.add(environment);
                    }
                    projectEnvironmentsMap.put(deploymentProject, environments);
                }
            }
        }
        catch (JSONException e) {
            log.error((Object)"Failed to parse Bamboo Deployment Project list", (Throwable)e);
            errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", applicationLink.getName()));
        }
        return new RestResult<Map<BambooDeploymentProject, List<BambooEnvironment>>>(projectEnvironmentsMap, errorCollection, response.getStatusCode());
    }

    private BambooDeploymentProject parseBambooDeploymentProject(JSONObject projectObject) throws JSONException {
        long projectId = projectObject.getLong("id");
        String projectKey = projectObject.getJSONObject("key").getString("key");
        String projectName = projectObject.getString("name");
        return new BambooDeploymentProject(projectId, projectKey, projectName);
    }

    private BambooEnvironment parseBambooEnvironment(JSONObject environmentObject) throws JSONException {
        long environmentId = environmentObject.getLong("id");
        String environmentKey = environmentObject.getJSONObject("key").getString("key");
        String environmentName = environmentObject.getString("name");
        return new BambooEnvironment(environmentId, environmentKey, environmentName);
    }

    private RestResult<PlanResultKey> executeTrigger(ApplicationLink applicationLink, String planKey, String stage, Map<String, String> params, TriggerType triggerType) throws CredentialsRequiredException {
        HashSet<String> errorCollection = new HashSet<String>();
        String url = "/rest/api/latest/queue/" + planKey + ".json";
        if (StringUtils.isNotBlank((String)stage)) {
            try {
                url = url + "?stage=" + URLCodec.encode((String)stage, (boolean)true);
            }
            catch (UnsupportedEncodingException e) {
                errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", applicationLink.getName()));
                log.error((Object)("Failed to trigger release build, requested stage name '" + stage + "' could not be encoded. "), (Throwable)e);
            }
        }
        BambooRestResponse response = triggerType == TriggerType.NEW ? this.executePostRequest(applicationLink, url, params, 50000) : this.executePutRequest(applicationLink, url, params, 50000, applicationLink.getName());
        JSONObject result = this.parseResponseForJsonObject(applicationLink.getName(), response, errorCollection);
        if (result != null) {
            try {
                String planResultKey = result.getString("buildResultKey");
                if (StringUtils.isNotBlank((String)planResultKey)) {
                    return new RestResult<PlanResultKey>(PlanKeys.getPlanResultKey(planResultKey), errorCollection, response.getStatusCode());
                }
                errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", applicationLink.getName()));
                log.error((Object)("Could not parse plan result key from Bamboo response: " + response.getResponseBody()));
            }
            catch (JSONException e) {
                errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", applicationLink.getName()));
                log.error((Object)"Failed to trigger build, could not parse response from Bamboo", (Throwable)e);
            }
        }
        return new RestResult<Object>(null, errorCollection, response.getStatusCode());
    }

    @Nullable
    private JSONObject parseResponseForJsonObject(String serverName, BambooRestResponse response, Collection<String> errorCollection) {
        return this.parseResponseForJsonObject(serverName, response, errorCollection, true);
    }

    @Nullable
    private JSONObject parseResponseForJsonObject(String serverName, BambooRestResponse response, Collection<String> errorCollection, boolean includeResponseBodyInError) {
        if (this.isResponseValid(serverName, response, errorCollection, includeResponseBodyInError)) {
            String responseBody = response.getResponseBody();
            if (responseBody != null && !responseBody.isEmpty()) {
                try {
                    return new JSONObject(responseBody);
                }
                catch (JSONException e) {
                    errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", serverName));
                    log.error((Object)("Bamboo Rest Request failed, could not parse response from " + serverName), (Throwable)e);
                }
            } else {
                errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", serverName));
                log.error((Object)("Bamboo Rest Request failed, no response received from " + serverName));
            }
        }
        return null;
    }

    private JSONArray parseResponseForJsonArray(String serverName, BambooRestResponse response, Collection<String> errorCollection, boolean includeResponseBodyInError) {
        if (this.isResponseValid(serverName, response, errorCollection, includeResponseBodyInError)) {
            String responseBody = response.getResponseBody();
            if (responseBody != null && !responseBody.isEmpty()) {
                try {
                    return new JSONArray(responseBody);
                }
                catch (JSONException e) {
                    errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", serverName));
                    log.error((Object)("Bamboo Rest Request failed, could not parse response from " + serverName), (Throwable)e);
                }
            } else {
                errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", serverName));
                log.error((Object)("Bamboo Rest Request failed, no response received from " + serverName));
            }
        }
        return null;
    }

    private boolean isResponseValid(String serverName, BambooRestResponse response, Collection<String> errorCollection, boolean includeResponseBodyInError) {
        boolean validResponse = true;
        if (!response.getErrors().isEmpty()) {
            errorCollection.addAll(response.getErrors());
            validResponse = false;
        } else if (!response.isValidStatusCode()) {
            errorCollection.add(this.getI18nHelper().getText("bamboo.error.connectivity", serverName));
            log.error((Object)String.format("Invalid return code received from %s. Response.statusCode: %d, statusMessage: %s, responseBody: %s", serverName, response.getStatusCode(), response.getStatusMessage(), includeResponseBodyInError ? response.getResponseBody() : "omitted"));
            validResponse = false;
        }
        return validResponse;
    }

    @Nonnull
    protected BambooRestResponse executePostRequest(@Nonnull ApplicationLink applicationLink, @Nonnull String url, @Nonnull Map<String, String> params, int timeout) throws CredentialsRequiredException {
        ApplicationLinkRequestFactory authenticatedRequestFactory = applicationLink.createAuthenticatedRequestFactory();
        return this.executePostRequest(authenticatedRequestFactory, url, params, timeout, applicationLink.getName());
    }

    @Nonnull
    protected BambooRestResponse executePostRequest(@Nonnull ApplicationLinkRequestFactory authenticatedRequestFactory, @Nonnull String url, @Nonnull Map<String, String> params, int timeout, String serverName) throws CredentialsRequiredException {
        ApplicationLinkRequest request = authenticatedRequestFactory.createRequest(Request.MethodType.POST, url);
        for (Map.Entry<String, String> param : params.entrySet()) {
            request.addRequestParameters(new String[]{param.getKey(), param.getValue()});
        }
        request.setHeader(X_ATLASSIAN_TOKEN, NO_CHECK);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        return this.executeRequest(request, authenticatedRequestFactory, timeout, serverName);
    }

    @Nonnull
    protected BambooRestResponse executePutRequest(@Nonnull ApplicationLink applicationLink, @Nonnull String url, @Nonnull Map<String, String> params, int timeout, String serverName) throws CredentialsRequiredException {
        ApplicationLinkRequestFactory authenticatedRequestFactory = applicationLink.createAuthenticatedRequestFactory();
        return this.executePutRequest(authenticatedRequestFactory, url, params, timeout, applicationLink.getName());
    }

    @Nonnull
    protected BambooRestResponse executePutRequest(@Nonnull ApplicationLinkRequestFactory authenticatedRequestFactory, @Nonnull String url, @Nonnull Map<String, String> params, int timeout, String serverName) throws CredentialsRequiredException {
        UrlBuilder urlBuilder = new UrlBuilder(url);
        for (Map.Entry<String, String> param : params.entrySet()) {
            urlBuilder.addParameter(param.getKey(), param.getValue());
        }
        ApplicationLinkRequest request = authenticatedRequestFactory.createRequest(Request.MethodType.PUT, urlBuilder.asUrlString());
        return this.executeRequest(request, authenticatedRequestFactory, timeout, serverName);
    }

    @Nonnull
    protected BambooRestResponse executeGetRequest(@Nonnull ApplicationLink applicationLink, @Nonnull String url, int timeout) throws CredentialsRequiredException {
        ApplicationLinkRequestFactory authenticatedRequestFactory = applicationLink.createAuthenticatedRequestFactory();
        return this.executeGetRequest(authenticatedRequestFactory, url, timeout, applicationLink.getName());
    }

    @Nonnull
    protected BambooRestResponse executeGetRequest(@Nonnull ApplicationLinkRequestFactory authenticatedRequestFactory, @Nonnull String url, int timeout, String serverName) throws CredentialsRequiredException {
        ApplicationLinkRequest request = authenticatedRequestFactory.createRequest(Request.MethodType.GET, url);
        return this.executeRequest(request, authenticatedRequestFactory, timeout, serverName);
    }

    @Nonnull
    protected BambooRestResponse executeRequest(ApplicationLinkRequest request, ApplicationLinkRequestFactory authenticatedRequestFactory, int timeout, String serverName) throws CredentialsRequiredException {
        request.setConnectionTimeout(timeout);
        request.setSoTimeout(timeout);
        return this.executeRequest(request, authenticatedRequestFactory, serverName);
    }

    @Nonnull
    protected BambooRestResponse executeRequest(ApplicationLinkRequest request, ApplicationLinkRequestFactory authenticatedRequestFactory, String serverName) throws CredentialsRequiredException {
        final String bambooErrorMsg = this.getI18nHelper().getText("bamboo.error.connectivity", serverName);
        try {
            BambooRestResponse response = (BambooRestResponse)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<BambooRestResponse>(){

                public BambooRestResponse handle(Response response) throws ResponseException {
                    return new BambooRestResponse(response, bambooErrorMsg);
                }

                public BambooRestResponse credentialsRequired(Response response) throws ResponseException {
                    return new CredentialsRequiredResponse(response, bambooErrorMsg);
                }
            });
            if (response instanceof CredentialsRequiredResponse) {
                throw new CredentialsRequiredException((AuthorisationURIGenerator)authenticatedRequestFactory, "Request failed. Credentials Required");
            }
            return response;
        }
        catch (ResponseException e) {
            log.error((Object)("Could not connect to " + serverName), (Throwable)e);
            return new BambooRestResponse(bambooErrorMsg);
        }
    }

    private I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }

    static enum TriggerType {
        NEW,
        EXISTING;

    }

    private static class CredentialsRequiredResponse
    extends BambooRestResponse {
        private CredentialsRequiredResponse(Response response, String failureErrorMsg) {
            super(response, failureErrorMsg);
        }
    }
}

