/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.sal.api.net.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class BambooRestResponse {
    private static final Logger log = Logger.getLogger(BambooRestResponse.class);
    public static final String MESSAGE = "message";
    private int statusCode = -1;
    private String statusMessage;
    private String responseBody;
    private final List<String> errors = new ArrayList<String>();

    public BambooRestResponse(int statusCode, @Nullable String statusMessage, @Nullable String responseBody, @Nonnull List<String> errors) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.responseBody = responseBody;
        this.errors.addAll(errors);
    }

    public BambooRestResponse(@Nonnull Response response, @Nonnull String failureMessage) {
        this.statusCode = response.getStatusCode();
        this.statusMessage = response.getStatusText();
        try {
            this.responseBody = IOUtils.toString((InputStream)response.getResponseBodyAsStream());
            JSONObject jsonObject = new JSONObject(this.responseBody);
            if (jsonObject.has(MESSAGE)) {
                this.errors.add(jsonObject.getString(MESSAGE));
            }
        }
        catch (JSONException jsonObject) {
        }
        catch (Throwable e) {
            this.errors.add(failureMessage);
            log.error((Object)failureMessage, e);
        }
    }

    public BambooRestResponse(String ... errors) {
        Collections.addAll(this.errors, errors);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public String getResponseBody() {
        return this.responseBody;
    }

    @Nonnull
    public List<String> getErrors() {
        return this.errors;
    }

    public boolean isValidStatusCode() {
        return this.statusCode < 300;
    }
}

