/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.model.BuildState;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.release.ReleaseFinalisingAction;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.jira.plugin.ext.bamboo.service.PlanExecutionResult;
import com.atlassian.jira.plugin.ext.bamboo.service.PlanResultStatusUpdateService;
import com.atlassian.jira.plugin.ext.bamboo.service.ReleaseErrorReportingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={BambooReleaseService.class, LifecycleAware.class})
@Component
public class BambooReleaseServiceImpl
implements BambooReleaseService,
LifecycleAware {
    private static final Logger log = Logger.getLogger(BambooReleaseServiceImpl.class);
    private static final String BAMBOO_TRIGGER_REASON_JIRA_BASE_URL = "bamboo.triggerReason.jiraBaseUrl";
    private static final String BAMBOO_TRIGGER_REASON_JIRA_PROJECT_KEY = "bamboo.triggerReason.jiraProjectKey";
    private static final String BAMBOO_TRIGGER_REASON_JIRA_PROJECT_NAME = "bamboo.triggerReason.jiraProjectName";
    private static final String BAMBOO_TRIGGER_REASON_JIRA_USER_DISPLAY_NAME = "bamboo.triggerReason.jiraUserDisplayName";
    private static final String BAMBOO_TRIGGER_REASON_JIRA_USERNAME = "bamboo.triggerReason.jiraUsername";
    private static final String BAMBOO_TRIGGER_REASON_JIRA_VERSION_ID = "bamboo.triggerReason.jiraVersionId";
    private static final String BAMBOO_TRIGGER_REASON_JIRA_VERSION_NAME = "bamboo.triggerReason.jiraVersion";
    private static final String CUSTOM_PLAN_TRIGGER_KEY = "bamboo.customPlanTriggerKey";
    private static final String CUSTOM_TRIGGER_REASON_KEY = "bamboo.customTriggerReasonKey";
    private static final String PLUGIN_PREFIX = "com.atlassian.bamboo.plugin.jira";
    private static final String PLAN_TRIGGER = "com.atlassian.bamboo.plugin.jira:jiraReleasePlanTrigger";
    private static final String TRIGGER_REASON = "com.atlassian.bamboo.plugin.jira:jiraReleaseTriggerReason";
    private final Function<Version, ManagedLock> versionReleaseLocks = ManagedLocks.weakManagedLockFactory();
    private final BambooRestService bambooRestService;
    private final DateFieldFormat dateFieldFormat;
    private final GlobalPermissionManager globalPermissionManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private final PermissionManager permissionManager;
    private final PlanResultStatusUpdateService planStatusUpdateService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ProjectManager projectManager;
    private final ReleaseErrorReportingService releaseErrorReportingService;
    private final SearchProvider searchProvider;
    private final UserManager userManager;
    private final VersionManager versionManager;

    @Autowired
    public BambooReleaseServiceImpl(@ComponentImport DateFieldFormat dateFieldFormat, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport IssueManager issueManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport JiraPropertySetFactory jiraPropertySetFactory, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ProjectManager projectManager, @ComponentImport SearchProvider searchProvider, @ComponentImport(value="jiraUserManager") UserManager userManager, @ComponentImport VersionManager versionManager, BambooRestService bambooRestService, PlanResultStatusUpdateService planStatusUpdateService, ReleaseErrorReportingService releaseErrorReportingService) {
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.dateFieldFormat = (DateFieldFormat)Preconditions.checkNotNull((Object)dateFieldFormat);
        this.globalPermissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)globalPermissionManager);
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager);
        this.jiraPropertySetFactory = (JiraPropertySetFactory)Preconditions.checkNotNull((Object)jiraPropertySetFactory);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.planStatusUpdateService = (PlanResultStatusUpdateService)Preconditions.checkNotNull((Object)planStatusUpdateService);
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
        this.releaseErrorReportingService = (ReleaseErrorReportingService)Preconditions.checkNotNull((Object)releaseErrorReportingService);
        this.searchProvider = (SearchProvider)Preconditions.checkNotNull((Object)searchProvider);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.versionManager = (VersionManager)Preconditions.checkNotNull((Object)versionManager);
    }

    @Override
    @Nonnull
    public PlanExecutionResult triggerPlanForRelease(@Nonnull ApplicationLink applicationLink, @Nonnull Version version, @Nonnull Map<String, String> settings) throws CredentialsRequiredException {
        Project project = version.getProject();
        String projectKey = project.getKey();
        this.clearErrors(version);
        this.clearBuildData(projectKey, version.getId());
        this.saveConfigData(projectKey, version, settings);
        Map<String, String> params = this.populateParams(version, settings, project);
        PlanKey planKey = PlanKeys.getPlanKey(settings.get("plan"));
        String stage = settings.get("stage");
        RestResult<PlanResultKey> restResult = this.bambooRestService.triggerPlan(applicationLink, planKey, stage, params);
        PlanResultKey planResultKey = restResult.getResult();
        if (planResultKey != null && restResult.getErrors().isEmpty()) {
            String userName = settings.get("user");
            this.subscribeToReleaseStatus(version, userName, planResultKey);
            this.registerReleaseStarted(projectKey, version.getId(), planResultKey);
        }
        return new PlanExecutionResult(restResult.getResult(), (List<String>)restResult.getErrors());
    }

    @Override
    @Nonnull
    public PlanExecutionResult triggerExistingBuildForRelease(@Nonnull ApplicationLink applicationLink, @Nonnull Version version, @Nonnull PlanResultKey planResultKey, @Nonnull Map<String, String> settings) throws CredentialsRequiredException {
        Project project = version.getProject();
        String projectKey = project.getKey();
        this.clearErrors(version);
        this.clearBuildData(projectKey, version.getId());
        this.saveConfigData(projectKey, version, settings);
        Map<String, String> params = this.populateParams(version, settings, project);
        String stage = settings.get("stage");
        RestResult<PlanResultKey> restResult = this.bambooRestService.continuePlan(applicationLink, planResultKey, stage, params);
        if (restResult.getErrors().isEmpty()) {
            String userName = settings.get("user");
            this.subscribeToReleaseStatus(version, userName, planResultKey);
            this.registerReleaseStarted(projectKey, version.getId(), planResultKey);
        }
        return new PlanExecutionResult(restResult.getResult(), (List<String>)restResult.getErrors());
    }

    @Override
    public void releaseWithNoBuild(Version version, Map<String, String> releaseConfig) {
        Project project = version.getProject();
        String projectKey = project.getKey();
        Long versionId = version.getId();
        this.clearErrors(version);
        this.clearConfigData(projectKey, versionId);
        this.clearBuildData(projectKey, versionId);
        this.saveConfigData(projectKey, version, releaseConfig);
        this.doJiraRelease(version, releaseConfig);
    }

    @Override
    public boolean releaseIfRequired(@Nonnull PlanResultStatus planResultStatus, @Nonnull Version version) {
        try {
            return (Boolean)((ManagedLock)this.versionReleaseLocks.get((Object)version)).withLock(() -> this.releaseWithoutLock(version, planResultStatus));
        }
        catch (Exception e) {
            log.error((Object)"Unexpected Error Has Occured Performing Release", (Throwable)e);
            return false;
        }
    }

    public void onStart() {
        Thread thread = new Thread((Runnable)new ReleaseBuildSubscriber(), "Bamboo Release Management Startup");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> log.error((Object)"Could not start Bamboo Release Management Plugin", throwable));
        thread.start();
    }

    public void onStop() {
    }

    @Override
    public void resetReleaseStateIfVersionWasUnreleased(@Nonnull Version version) {
        Project project = version.getProject();
        String projectKey = project.getKey();
        Long versionId = version.getId();
        if (!version.isReleased() && this.getBuildState(projectKey, versionId) == BuildState.SUCCESS && this.isReleaseCompleted(projectKey, versionId)) {
            this.clearConfigData(projectKey, versionId);
            this.clearBuildData(projectKey, versionId);
        }
    }

    @Override
    public void clearConfigData(@Nonnull String projectKey, long versionId) {
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        settingsForKey.remove("bamboo.release.config." + versionId);
    }

    @Override
    @Nullable
    public Map<String, String> getConfigData(@Nonnull String projectKey, long versionId) {
        return this.getConfigMap(projectKey, "bamboo.release.config." + versionId);
    }

    @Override
    @Nonnull
    public Map<String, String> getDefaultSettings(@Nonnull String projectKey) {
        HashMap settings = this.getConfigMap(projectKey, "bamboo.release.config.defaults");
        return settings != null ? settings : Maps.newHashMap();
    }

    @Override
    @Nullable
    public Map<String, String> getBuildData(@Nonnull String projectKey, long versionId) {
        return this.getConfigMap(projectKey, "bamboo.release.build." + versionId);
    }

    @Override
    public void registerReleaseStarted(@Nonnull String projectKey, long versionId, @Nonnull PlanResultKey planResultKey) {
        Map<String, String> data = Collections.singletonMap("result", planResultKey.getKey());
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        settingsForKey.put("bamboo.release.build." + versionId, data);
    }

    private void registerReleaseFinished(@Nonnull String projectKey, long versionId, @Nonnull PlanResultKey planResultKey, BuildState buildState) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("result", planResultKey.getKey());
        data.put("state", buildState.name());
        data.put("completed", Boolean.TRUE.toString());
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        settingsForKey.put("bamboo.release.build." + versionId, data);
    }

    @Override
    public boolean hasPermissionToRelease(@Nullable ApplicationUser user, @Nonnull Project project) {
        return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    @Override
    public boolean hasPermissionToRelease(@Nullable User user, @Nonnull Project project) {
        return this.hasPermissionToRelease(ApplicationUsers.from((User)user), project);
    }

    @Override
    @Nonnull
    public Map<String, String> getBambooVariablesFromMap(@Nonnull Map<String, String> toFilter, @Nonnull String prefixSubstitute) {
        return toFilter.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("variable_")).filter(entry -> StringUtils.isNotBlank((String)((String)entry.getValue()))).collect(Collectors.toMap(entry -> ((String)entry.getKey()).replace("variable_", prefixSubstitute), Map.Entry::getValue));
    }

    @VisibleForTesting
    void doJiraRelease(Version version, Map<String, String> releaseConfig) {
        if (!version.isReleased()) {
            String openIssuesAction = releaseConfig.get("openIssuesAction");
            if ("move".equals(openIssuesAction)) {
                String userName = releaseConfig.get("user");
                ApplicationUser user = this.userManager.getUserByName(userName);
                String newVersionId = releaseConfig.get("openIssuesMoveVersion");
                Version newVersion = this.versionManager.getVersion(Long.valueOf(Long.parseLong(newVersionId)));
                try {
                    Collection<Issue> issues = this.getUnresolvedIssues(version, user);
                    if (!issues.isEmpty()) {
                        for (Issue issue : issues) {
                            MutableIssue mutableIssue = this.issueManager.getIssueObject(issue.getId());
                            Collection versions = mutableIssue.getFixVersions();
                            versions.remove(version);
                            versions.add(newVersion);
                            mutableIssue.setFixVersions(versions);
                            this.issueManager.updateIssue(user, mutableIssue, UpdateIssueRequest.builder().eventDispatchOption(EventDispatchOption.ISSUE_UPDATED).sendMail(true).build());
                        }
                    }
                }
                catch (Exception e) {
                    String message = this.authenticationContext.getI18nHelper().getText("jira.error.not.recoverable", (Object)newVersion);
                    this.releaseErrorReportingService.recordError(version.getProject().getKey(), version.getId(), message);
                    log.error((Object)message, (Throwable)e);
                    return;
                }
            }
            Date releaseDate = this.dateFieldFormat.parseDatePicker(releaseConfig.get("releaseDate"));
            Version editedVersion = this.versionManager.editVersionReleaseDate(version, releaseDate);
            this.versionManager.releaseVersion(editedVersion, true);
        }
    }

    private Map<String, String> populateParams(Version version, Map<String, String> settings, Project project) {
        HashMap params = Maps.newHashMap();
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        params.put(CUSTOM_PLAN_TRIGGER_KEY, PLAN_TRIGGER);
        params.put(CUSTOM_TRIGGER_REASON_KEY, TRIGGER_REASON);
        params.put(BAMBOO_TRIGGER_REASON_JIRA_USERNAME, user.getName());
        params.put(BAMBOO_TRIGGER_REASON_JIRA_USER_DISPLAY_NAME, user.getDisplayName());
        params.put(BAMBOO_TRIGGER_REASON_JIRA_PROJECT_NAME, project.getName());
        params.put(BAMBOO_TRIGGER_REASON_JIRA_PROJECT_KEY, project.getKey());
        params.put(BAMBOO_TRIGGER_REASON_JIRA_VERSION_NAME, version.getName());
        params.put(BAMBOO_TRIGGER_REASON_JIRA_VERSION_ID, version.getId().toString());
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        params.put(BAMBOO_TRIGGER_REASON_JIRA_BASE_URL, baseUrl);
        params.putAll(this.getBambooVariablesFromMap(settings, "bamboo.variable."));
        return params;
    }

    private boolean releaseWithoutLock(Version version, PlanResultStatus planResultStatus) {
        Project project = version.getProject();
        boolean released = false;
        if (!version.isReleased()) {
            if (BuildState.SUCCESS == planResultStatus.getBuildState()) {
                Map<String, String> releaseConfig = this.getConfigData(project.getKey(), version.getId());
                log.info((Object)("Bamboo Release Plugin releasing version " + version.getName() + " of project " + project.getKey()));
                if (releaseConfig != null) {
                    this.doJiraRelease(version, releaseConfig);
                    released = true;
                    this.clearConfigData(project.getKey(), version.getId());
                } else {
                    String errorMessage = this.authenticationContext.getI18nHelper().getText("bamboo.error.release.retry.manually");
                    this.releaseErrorReportingService.recordError(project.getKey(), version.getId(), errorMessage);
                    log.error((Object)("Release build " + planResultStatus.getPlanResultKey() + " completed but no record of triggering the release can be found.  Version was not released."));
                }
            }
            this.registerReleaseFinished(project.getKey(), version.getId(), planResultStatus.getPlanResultKey(), planResultStatus.getBuildState() != null ? planResultStatus.getBuildState() : BuildState.UNKNOWN);
        }
        return released;
    }

    private Collection<Issue> getUnresolvedIssues(Version version, ApplicationUser user) {
        try {
            JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{version.getProject().getId()}).and().unresolved();
            builder.and().fixVersion(version.getId());
            SearchResults results = this.searchProvider.search(builder.buildQuery(), user, PagerFilter.getUnlimitedFilter());
            return results.getIssues();
        }
        catch (Exception e) {
            log.error((Object)("Exception whilst getting unresolved issues " + e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    private Map<String, String> getConfigMap(String projectKey, String configKey) {
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        Object o = settingsForKey.get(configKey);
        if (o != null && Map.class.isAssignableFrom(o.getClass())) {
            return (Map)o;
        }
        return null;
    }

    private void subscribeToReleaseStatus(@Nonnull Version version, @Nonnull String username, @Nonnull PlanResultKey planResultKey) {
        ReleaseFinalisingAction action = new ReleaseFinalisingAction(this, this.authenticationContext.getI18nHelper(), this.releaseErrorReportingService, version.getId(), this.versionManager);
        this.planStatusUpdateService.subscribe(version, planResultKey, username, action);
    }

    private void saveConfigData(@Nonnull String projectKey, @Nonnull Version version, @Nonnull Map<String, String> config) {
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        settingsForKey.put("bamboo.release.config." + version.getId(), config);
        settingsForKey.put("bamboo.release.config.defaults", config);
    }

    private void clearErrors(Version version) {
        this.releaseErrorReportingService.clearErrors(version.getProject().getKey(), version.getId());
    }

    private boolean isReleaseCompleted(@Nonnull String projectKey, long versionId) {
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        Map config = (Map)settingsForKey.get("bamboo.release.build." + versionId);
        return config != null && config.containsKey("completed");
    }

    private BuildState getBuildState(@Nonnull String projectKey, long versionId) {
        String state;
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        Map config = (Map)settingsForKey.get("bamboo.release.build." + versionId);
        if (config != null && StringUtils.isNotEmpty((String)(state = (String)config.get("state")))) {
            try {
                return BuildState.valueOf(state);
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)"Could not determine BuildState from Plugin Settings. Falling back to 'UNKNOWN'", (Throwable)e);
            }
        }
        return BuildState.UNKNOWN;
    }

    private void clearBuildData(@Nonnull String projectKey, long versionId) {
        PluginSettings settingsForKey = this.pluginSettingsFactory.createSettingsForKey(projectKey);
        settingsForKey.remove("bamboo.release.build." + versionId);
    }

    private class ReleaseBuildSubscriber
    implements Runnable {
        private ReleaseBuildSubscriber() {
        }

        @Override
        public void run() {
            for (Project project : BambooReleaseServiceImpl.this.projectManager.getProjectObjects()) {
                Collection versions = project.getVersions();
                if (versions.isEmpty()) continue;
                PluginSettings projectSettings = BambooReleaseServiceImpl.this.pluginSettingsFactory.createSettingsForKey(project.getKey());
                Collection<String> releaseBuildKeys = this.getReleaseBuildKeys(project);
                for (Version version : versions) {
                    this.subscribeToReleaseBuildUpdates(projectSettings, releaseBuildKeys, version);
                }
            }
        }

        private void subscribeToReleaseBuildUpdates(PluginSettings projectSettings, Collection<String> releaseBuildKeys, Version version) {
            Map releaseBuild;
            String releaseBuildKey = "bamboo.release.build." + version.getId();
            if (releaseBuildKeys.contains(releaseBuildKey) && (releaseBuild = (Map)projectSettings.get(releaseBuildKey)) != null) {
                String buildResultKey = (String)releaseBuild.get("result");
                boolean isCompleted = releaseBuild.containsKey("state");
                String username = (String)releaseBuild.get("user");
                if (StringUtils.isNotEmpty((String)buildResultKey) && StringUtils.isNotEmpty((String)username) && !isCompleted) {
                    PlanResultKey planResultKey = PlanKeys.getPlanResultKey(buildResultKey);
                    BambooReleaseServiceImpl.this.subscribeToReleaseStatus(version, username, planResultKey);
                }
            }
        }

        private Collection<String> getReleaseBuildKeys(Project project) {
            PropertySet projectProperties = BambooReleaseServiceImpl.this.jiraPropertySetFactory.buildCachingDefaultPropertySet(project.getKey());
            return projectProperties.getKeys("bamboo.release.build.");
        }
    }
}

