/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.service;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class BambooContentRewriter {
    private static final Logger log = Logger.getLogger(BambooContentRewriter.class);

    public String rewriteHtml(String relativeUrl, String serverBaseUrl) {
        if (relativeUrl == null || serverBaseUrl == null) {
            return null;
        }
        String context = this.getContextPathWithSlash(serverBaseUrl);
        if (!serverBaseUrl.endsWith("/")) {
            serverBaseUrl = serverBaseUrl + "/";
        }
        relativeUrl = relativeUrl.replaceAll("src=\"" + context, "src=\"" + serverBaseUrl);
        relativeUrl = relativeUrl.replaceAll("href=\"" + context, "href=\"" + serverBaseUrl);
        return relativeUrl;
    }

    String getContextPathWithSlash(String host) {
        try {
            URI hostURI = new URI(host, false);
            String escapedPath = StringUtils.trimToEmpty((String)hostURI.getEscapedPath());
            if (!escapedPath.endsWith("/")) {
                return escapedPath + "/";
            }
            return escapedPath;
        }
        catch (URIException e) {
            String message = "Unable to parse URL " + host;
            log.error((Object)message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }
}

