/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.server;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class BambooServerInfo {
    private static final Logger log = Logger.getLogger(BambooServerInfo.class);
    private final int buildNumber;
    private final String version;

    public BambooServerInfo(String version, int buildNumber) {
        this.version = version;
        this.buildNumber = buildNumber;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public static BambooServerInfo fromJSON(JSONObject jsonObject, Collection<String> errorCollection) {
        if (jsonObject != null) {
            try {
                String version = jsonObject.getString("version");
                int buildNumber = jsonObject.getInt("buildNumber");
                return new BambooServerInfo(version, buildNumber);
            }
            catch (Exception e) {
                log.warn((Object)"error parsing Bamboo server status", (Throwable)e);
                errorCollection.add("error parsing Bamboo server status: " + e.getMessage());
                return null;
            }
        }
        return null;
    }
}

