/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.rest;

import com.atlassian.jira.plugin.ext.bamboo.service.ReleaseErrorReportingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/errors")
@Scanned
public class JBAMErrorManagementResource {
    private static final Logger log = Logger.getLogger(JBAMErrorManagementResource.class);
    private final ReleaseErrorReportingService releaseErrorReportingService;
    private final VersionManager versionManager;

    public JBAMErrorManagementResource(ReleaseErrorReportingService releaseErrorReportingService, @ComponentImport VersionManager versionManager) {
        this.releaseErrorReportingService = (ReleaseErrorReportingService)Preconditions.checkNotNull((Object)releaseErrorReportingService);
        this.versionManager = (VersionManager)Preconditions.checkNotNull((Object)versionManager);
    }

    @DELETE
    @Path(value="/{versionId}")
    @Produces(value={"application/json"})
    public Response deleteErrors(@Nonnull @PathParam(value="versionId") Long versionId) {
        try {
            Preconditions.checkNotNull((Object)versionId, (Object)"versionId");
            Version version = this.versionManager.getVersion(versionId);
            if (version == null) {
                log.warn((Object)("Could not clear release errors for version, no version with the id '" + versionId + "' could be found"));
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Project project = version.getProject();
            this.releaseErrorReportingService.clearErrors(project.getKey(), version.getId());
            return Response.ok().build();
        }
        catch (RuntimeException e) {
            log.warn((Object)("Could not clear release errors for version " + versionId + " : " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

