/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.BuildState;
import com.atlassian.jira.plugin.ext.bamboo.model.ErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.OAuthErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultStatus;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/status")
@Scanned
public class BambooStatusResource {
    private static final Logger log = Logger.getLogger(BambooStatusResource.class);
    private static final String BAMBOO = "bamboo";
    private static final String JIRA = "jira";
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooReleaseService bambooReleaseService;
    private final BambooRestService bambooRestService;
    private final I18nResolver i18nResolver;
    private final VersionManager versionManager;

    public BambooStatusResource(@ComponentImport I18nResolver i18nResolver, @ComponentImport VersionManager versionManager, BambooApplicationLinkManager bambooApplicationLinkManager, BambooReleaseService bambooReleaseService, BambooRestService bambooRestService) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooReleaseService = (BambooReleaseService)Preconditions.checkNotNull((Object)bambooReleaseService);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.versionManager = (VersionManager)Preconditions.checkNotNull((Object)versionManager);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{jiraVersionId}/{planResultKey}")
    public Response getStatus(@PathParam(value="planResultKey") String resultKey, @PathParam(value="jiraVersionId") long jiraVersionId) {
        Version version = this.versionManager.getVersion(Long.valueOf(jiraVersionId));
        if (version == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ApplicationLink bambooApplicationLink = this.bambooApplicationLinkManager.getApplicationLink(version.getProject().getKey());
        if (bambooApplicationLink == null) {
            return Response.serverError().build();
        }
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey(resultKey);
        try {
            RestResult<JSONObject> restResult = this.bambooRestService.getPlanResultJson(bambooApplicationLink.createAuthenticatedRequestFactory(), planResultKey);
            JSONObject bambooJsonObject = restResult.getResult();
            if (bambooJsonObject == null) {
                ErrorMessage errorMessage = new ErrorMessage(this.i18nResolver.getText("bamboo.unreachable"), restResult.getErrorMessage(this.i18nResolver.getText("bamboo.error.connectivity", new Serializable[]{bambooApplicationLink.getName()})));
                return errorMessage.createJSONEntity(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
            }
            PlanResultStatus planResultStatus = this.getPlanResultStatusFromJSON(planResultKey, bambooJsonObject);
            JSONObject jiraJsonObject = new JSONObject();
            if (!version.isReleased() && planResultStatus.getBuildState() != BuildState.UNKNOWN) {
                String state;
                Map<String, String> buildParams = this.bambooReleaseService.getBuildData(version.getProject().getKey(), version.getId());
                if (buildParams != null && (state = buildParams.get("state")) == null) {
                    this.bambooReleaseService.releaseIfRequired(planResultStatus, version);
                    jiraJsonObject.put("forceRefresh", true);
                }
                jiraJsonObject.put("released", this.versionManager.getVersion(Long.valueOf(jiraVersionId)).isReleased());
            } else {
                jiraJsonObject.put("released", version.isReleased());
            }
            JSONObject result = new JSONObject();
            result.put(BAMBOO, (Object)bambooJsonObject);
            result.put(JIRA, (Object)jiraJsonObject);
            return Response.ok((Object)result.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (CredentialsRequiredException e) {
            log.debug((Object)"Credentials required", (Throwable)e);
            String description = this.i18nResolver.getText("bamboo.loginAndApprove.release.status");
            return new OAuthErrorMessage(description, e.getAuthorisationURI()).createJSONEntity(Response.status((Response.Status)Response.Status.UNAUTHORIZED)).build();
        }
        catch (JSONException e) {
            log.error((Object)"Failed to parse status response from Bamboo", (Throwable)e);
            return Response.serverError().build();
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected server error", (Throwable)e);
            return Response.serverError().build();
        }
    }

    protected PlanResultStatus getPlanResultStatusFromJSON(PlanResultKey planResultKey, JSONObject bambooJsonObject) throws JSONException {
        return PlanResultStatus.fromJsonObject(planResultKey, bambooJsonObject);
    }
}

