/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.ErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.OAuthErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/history")
@Scanned
public class BambooResultHistoryResource {
    private static final Logger log = Logger.getLogger(BambooResultHistoryResource.class);
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooRestService bambooRestService;
    private final I18nResolver i18nResolver;

    private static Map<String, String> getQueryParams(UriInfo uriInfo) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        HashMap result = Maps.newHashMap();
        if (!params.isEmpty()) {
            for (String key : params.keySet()) {
                result.put(key, params.getFirst((Object)key));
            }
        }
        return result;
    }

    public BambooResultHistoryResource(@ComponentImport I18nResolver i18nResolver, BambooApplicationLinkManager bambooApplicationLinkManager, BambooRestService bambooRestService) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    @GET
    @Path(value="/{jiraProjectKey}/{planKey}/{numberOfResults}")
    @Produces(value={"application/json"})
    public Response getHistory(@PathParam(value="jiraProjectKey") String projectKey, @PathParam(value="planKey") String key, @PathParam(value="numberOfResults") int numberOfResults, @Context UriInfo uriInfo) {
        ApplicationLink bambooApplicationLink = this.bambooApplicationLinkManager.getApplicationLink(projectKey);
        if (bambooApplicationLink == null) {
            return Response.serverError().build();
        }
        PlanKey planKey = PlanKeys.getPlanKey(key);
        try {
            RestResult<JSONObject> result = this.bambooRestService.getPlanHistory(bambooApplicationLink.createAuthenticatedRequestFactory(), planKey, numberOfResults, BambooResultHistoryResource.getQueryParams(uriInfo));
            JSONObject jsonObject = result.getResult();
            if (jsonObject == null) {
                String title = this.i18nResolver.getText("bamboo.unreachable");
                String message = this.i18nResolver.getText("bamboo.error.connectivity", new Serializable[]{bambooApplicationLink.getName()});
                ErrorMessage errorMessage = new ErrorMessage(title, result.getErrorMessage(message));
                return errorMessage.createJSONEntity(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
            }
            return Response.ok((Object)jsonObject.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (IllegalArgumentException e) {
            log.info((Object)("Unable to get history for plan " + planKey + " numberOfResults: " + numberOfResults), (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("message", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                return Response.serverError().build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)jsonObject.toString()).build();
        }
        catch (CredentialsRequiredException e) {
            log.debug((Object)"Credentials required", (Throwable)e);
            String description = this.i18nResolver.getText("bamboo.loginAndApprove.release");
            return new OAuthErrorMessage(description, e.getAuthorisationURI()).createJSONEntity(Response.status((Response.Status)Response.Status.UNAUTHORIZED)).build();
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected server error", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

