/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.ErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.OAuthErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@Path(value="/plan")
@Scanned
public class BambooPlanResource {
    private static final Logger log = Logger.getLogger(BambooPlanResource.class);
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooRestService bambooRestService;
    private final I18nResolver i18nResolver;

    public BambooPlanResource(@ComponentImport I18nResolver i18nResolver, BambooApplicationLinkManager bambooApplicationLinkManager, BambooRestService bambooRestService) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    @GET
    @Path(value="{jiraProjectKey}/{planKey}")
    @Produces(value={"application/json"})
    public Response getPlan(@PathParam(value="jiraProjectKey") String projectKey, @PathParam(value="planKey") String key) {
        ApplicationLink bambooApplicationLink = this.bambooApplicationLinkManager.getApplicationLink(projectKey);
        if (bambooApplicationLink == null) {
            return Response.serverError().build();
        }
        PlanKey planKey = PlanKeys.getPlanKey(key);
        try {
            RestResult<JSONObject> result = this.bambooRestService.getPlanJson(bambooApplicationLink.createAuthenticatedRequestFactory(), planKey);
            JSONObject jsonObject = result.getResult();
            if (jsonObject == null) {
                ErrorMessage errorMessage = new ErrorMessage(this.i18nResolver.getText("bamboo.unreachable"), result.getErrorMessage(this.i18nResolver.getText("bamboo.error.connectivity", new Serializable[]{bambooApplicationLink.getName()})));
                return errorMessage.createJSONEntity(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
            }
            return Response.ok((Object)jsonObject.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (CredentialsRequiredException e) {
            log.debug((Object)"Credentials required", (Throwable)e);
            String description = this.i18nResolver.getText("bamboo.loginAndApprove.release");
            return new OAuthErrorMessage(description, e.getAuthorisationURI()).createJSONEntity(Response.status((Response.Status)Response.Status.UNAUTHORIZED)).build();
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected server error", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

