/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.ErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.OAuthErrorMessage;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.server.BambooServerInfo;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/deploy")
@Scanned
public class BambooDeploymentProjectResource {
    public static final int BAMBOO_5_1_BUILD_NUMBER = 3815;
    public static final String BAMBOO_ID_KEY = "bambooId";
    public static final String ID_KEY = "id";
    private static final Logger log = Logger.getLogger(BambooDeploymentProjectResource.class);
    private static final String APPLINK_ID_JSON_KEY = "applinkId";
    private static final String DEP_PROJECT_NAME_JSON_KEY = "name";
    private static final String DEPLOYMENT_PROJECTS_JSON_KEY = "deploymentProjects";
    private static final String OAUTH_CALLBACK_KEY = "oauthCallback";
    private static final String OAUTH_CALLBACKS_KEY = "oauthCallbacks";
    private static final String SERVER_NAME_KEY = "serverName";
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooRestService bambooRestService;
    private final I18nResolver i18nResolver;
    private Ordering<JSONObject> DEPLOYMENT_JSON_ORDERING = new Ordering<JSONObject>(){

        public int compare(JSONObject left, JSONObject right) {
            try {
                if (left == null || right == null) {
                    return left == right ? 0 : (left == null ? -1 : 1);
                }
                return new CompareToBuilder().append((Object)left.getString(BambooDeploymentProjectResource.DEP_PROJECT_NAME_JSON_KEY), (Object)right.getString(BambooDeploymentProjectResource.DEP_PROJECT_NAME_JSON_KEY)).toComparison();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public BambooDeploymentProjectResource(@ComponentImport I18nResolver i18nResolver, BambooRestService bambooRestService, BambooApplicationLinkManager bambooApplicationLinkManager) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    @GET
    @Path(value="/{jiraIssueKey}/{applinkId}/{deploymentProjectId}")
    @Produces(value={"application/json"})
    public Response getIssueDeploymentStatus(@PathParam(value="deploymentProjectId") String deploymentProjectId, @PathParam(value="jiraIssueKey") String jiraIssueKey, @PathParam(value="applinkId") String applinkId) {
        ApplicationLink bambooApplicationLink = this.bambooApplicationLinkManager.getBambooApplicationLink(applinkId);
        if (bambooApplicationLink == null) {
            return Response.serverError().build();
        }
        try {
            RestResult<JSONObject> result = this.bambooRestService.getIssueDeploymentStatus(bambooApplicationLink, jiraIssueKey, deploymentProjectId);
            JSONObject jsonObject = result.getResult();
            if (jsonObject == null) {
                ErrorMessage errorMessage = new ErrorMessage(this.i18nResolver.getText("bamboo.unreachable"), result.getErrorMessage(this.i18nResolver.getText("bamboo.error.connectivity", new Serializable[]{bambooApplicationLink.getName()})));
                return errorMessage.createJSONEntity(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
            }
            return Response.ok((Object)jsonObject.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (CredentialsRequiredException e) {
            log.debug((Object)"Credentials required", (Throwable)e);
            return new OAuthErrorMessage(this.i18nResolver.getText("bamboo.loginAndApprove.deployments", new Serializable[]{bambooApplicationLink.getName()}), e.getAuthorisationURI()).createJSONEntity(Response.status((Response.Status)Response.Status.UNAUTHORIZED)).build();
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected server error", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{jiraProjectKey}/{jiraIssueKey}")
    @Produces(value={"application/json"})
    public Response getIssueDeploymentStatus(@PathParam(value="jiraProjectKey") String jiraProjectKey, @PathParam(value="jiraIssueKey") String jiraIssueKey) {
        Iterable<ApplicationLink> bambooApplicationLinks = this.bambooApplicationLinkManager.getApplicationLinks(BambooApplicationLinkManager.Filter.SKIP_LINKS_WITH_DEPLOYMENT_SUMMARY_CAPABILITY_IF_FUSION_ENABLED);
        try {
            JSONObject aggregatedResult = new JSONObject();
            ArrayList deploymentProjectsJSONObjects = Lists.newArrayList();
            for (ApplicationLink bambooApplicationLink : bambooApplicationLinks) {
                HashSet associatedJiraProjects = Sets.newHashSet(this.bambooApplicationLinkManager.getProjects(bambooApplicationLink.getId().toString()));
                if (!associatedJiraProjects.isEmpty() && !associatedJiraProjects.contains(jiraProjectKey)) continue;
                try {
                    ApplicationLinkRequestFactory requestFactory = bambooApplicationLink.createAuthenticatedRequestFactory();
                    RestResult<JSONObject> result = this.bambooRestService.getDeploymentProjectsForIssue(requestFactory, bambooApplicationLink.getName(), jiraIssueKey);
                    JSONObject bambooResponse = result.getResult();
                    if (bambooResponse == null) {
                        if (this.is404FromOldBamboo(result, requestFactory)) continue;
                        log.warn((Object)result.getErrorMessage(""));
                        continue;
                    }
                    try {
                        deploymentProjectsJSONObjects.addAll(this.extractDeploymentProjectsFromResponse(bambooResponse, bambooApplicationLink.getId()));
                    }
                    catch (JSONException e) {
                        log.warn((Object)"", (Throwable)e);
                    }
                }
                catch (CredentialsRequiredException e) {
                    log.debug((Object)"Credentials required", (Throwable)e);
                    aggregatedResult.append(OAUTH_CALLBACKS_KEY, (Object)this.createOauthCallbackJson(bambooApplicationLink.getName(), e.getAuthorisationURI()));
                }
                catch (Exception e) {
                    log.warn((Object)"", (Throwable)e);
                }
            }
            for (JSONObject deploymentJSONObject : this.DEPLOYMENT_JSON_ORDERING.sortedCopy((Iterable)deploymentProjectsJSONObjects)) {
                aggregatedResult.append(DEPLOYMENT_PROJECTS_JSON_KEY, (Object)deploymentJSONObject);
            }
            return Response.ok((Object)aggregatedResult.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            log.error((Object)"Unexpected server error", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private JSONObject createOauthCallbackJson(String name, URI authorisationURI) throws JSONException {
        return new JSONObject().put(SERVER_NAME_KEY, (Object)name).put(OAUTH_CALLBACK_KEY, (Object)authorisationURI.toString());
    }

    private boolean is404FromOldBamboo(RestResult<JSONObject> result, ApplicationLinkRequestFactory requestFactory) {
        try {
            RestResult<BambooServerInfo> serverInfoRestResult;
            BambooServerInfo serverInfo;
            if (result.getStatusCode() == 404 && (serverInfo = (serverInfoRestResult = this.bambooRestService.getBambooServerInfo(requestFactory)).getResult()) != null && serverInfo.getBuildNumber() < 3815) {
                log.info((Object)("Bamboo server version " + serverInfo.getVersion() + " does not support Deployments REST endpoint. Suppressing error 404"));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Collection<? extends JSONObject> extractDeploymentProjectsFromResponse(JSONObject bambooResponse, ApplicationId bambooApplinkId) throws JSONException {
        ArrayList result = Lists.newArrayList();
        JSONArray deploymentsArray = bambooResponse.getJSONArray(DEPLOYMENT_PROJECTS_JSON_KEY);
        for (int i = 0; i < deploymentsArray.length(); ++i) {
            JSONObject deploymentJSONObject = deploymentsArray.getJSONObject(i);
            Integer bambooId = deploymentJSONObject.getInt(ID_KEY);
            deploymentJSONObject.remove(ID_KEY);
            deploymentJSONObject.put(BAMBOO_ID_KEY, (Object)bambooId);
            deploymentJSONObject.get(DEP_PROJECT_NAME_JSON_KEY);
            deploymentJSONObject.put(APPLINK_ID_JSON_KEY, (Object)bambooApplinkId.toString());
            result.add(deploymentJSONObject);
        }
        return result;
    }
}

