/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.release;

import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultStatus;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.ext.bamboo.service.PlanResultStatusUpdateService;
import com.atlassian.jira.plugin.ext.bamboo.service.ReleaseErrorReportingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.log4j.Logger;

@Scanned
public class ReleaseFinalisingAction
implements PlanResultStatusUpdateService.FinalizingAction {
    private static final Logger log = Logger.getLogger(ReleaseFinalisingAction.class);
    private final BambooReleaseService bambooReleaseService;
    private final I18nHelper i18nHelper;
    private final long versionId;
    private final VersionManager versionManager;
    private final ReleaseErrorReportingService releaseErrorReportingService;

    public ReleaseFinalisingAction(BambooReleaseService bambooReleaseService, @ComponentImport I18nHelper i18nHelper, ReleaseErrorReportingService releaseErrorReportingService, long versionId, @ComponentImport VersionManager versionManager) {
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
        this.bambooReleaseService = (BambooReleaseService)Preconditions.checkNotNull((Object)bambooReleaseService);
        this.releaseErrorReportingService = (ReleaseErrorReportingService)Preconditions.checkNotNull((Object)releaseErrorReportingService);
        this.versionId = versionId;
        this.versionManager = (VersionManager)Preconditions.checkNotNull((Object)versionManager);
    }

    @Override
    public void execute(PlanResultStatus planStatus) {
        Version version = this.versionManager.getVersion(Long.valueOf(this.versionId));
        Project project = version.getProject();
        Map<String, String> buildData = this.bambooReleaseService.getBuildData(project.getKey(), version.getId());
        if (buildData == null || buildData.get("result") == null) {
            log.error((Object)("Release build " + planStatus.getPlanResultKey() + " completed but no record of triggering the release can be found.  Version was not released."));
        } else if (!buildData.get("result").equals(planStatus.getPlanResultKey().getKey())) {
            log.error((Object)("Release build " + planStatus.getPlanResultKey() + " completed but it does not match the Plan Result we were waiting for (" + buildData.get("result") + ").  Version was not released."));
        } else {
            this.bambooReleaseService.releaseIfRequired(planStatus, version);
        }
    }
}

