/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.release;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.model.BambooPlan;
import com.atlassian.jira.plugin.ext.bamboo.model.BambooProject;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKeys;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import com.atlassian.jira.plugin.ext.bamboo.model.RestResult;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooRestService;
import com.atlassian.jira.plugin.ext.bamboo.service.PlanExecutionResult;
import com.atlassian.jira.plugin.ext.bamboo.service.ProjectVersionService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;
import webwork.action.ActionContext;

@Scanned
public class ConfigureBambooRelease
extends ProjectActionSupport {
    @VisibleForTesting
    static final String INCORRECT_DATE_FORMAT = "admin.errors.incorrect.date.format";
    @VisibleForTesting
    static final String RELEASE_DATE_FIELD = "releaseDate";
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooReleaseService bambooReleaseService;
    private final BambooRestService bambooRestService;
    private final DateFieldFormat dateFieldFormat;
    private final PermissionManager permissionManager;
    private final ProjectVersionService projectVersionService;
    private final VersionManager versionManager;
    private final VersionService versionService;
    private boolean bambooLinked;
    private int openIssueCount;
    private long versionId;
    private Collection<Version> versions;
    private Date releaseDate;
    private Long moveUnfixedIssuesTo;
    private Map<BambooProject, List<BambooPlan>> plansByProject;
    private String buildResult;
    private String buildType;
    private String currentReleaseDate = "";
    private String formattedReleaseDate = "";
    private String dateFormat = "";
    private String selectedPlanKey;
    private String selectedStages;
    private String unresolved;
    private String userReleaseDate;
    private String variablesJson;
    private URI credentialsUrl;
    private Version version;
    private String redirectUrlOnSuccess;
    private String applicationLinkName;

    public ConfigureBambooRelease(@ComponentImport DateFieldFormat dateFieldFormat, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport VersionManager versionManager, @ComponentImport VersionService versionService, BambooApplicationLinkManager bambooApplicationLinkManager, BambooReleaseService bambooReleaseService, BambooRestService bambooRestService, ProjectVersionService projectVersionService) {
        super(projectManager, permissionManager);
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooReleaseService = (BambooReleaseService)Preconditions.checkNotNull((Object)bambooReleaseService);
        this.bambooRestService = (BambooRestService)Preconditions.checkNotNull((Object)bambooRestService);
        this.dateFieldFormat = (DateFieldFormat)Preconditions.checkNotNull((Object)dateFieldFormat);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectVersionService = (ProjectVersionService)Preconditions.checkNotNull((Object)projectVersionService);
        this.versionManager = (VersionManager)Preconditions.checkNotNull((Object)versionManager);
        this.versionService = (VersionService)Preconditions.checkNotNull((Object)versionService);
    }

    public String doInput() {
        Map<String, String> previousConfiguration;
        this.applicationLinkName = "";
        this.version = this.versionManager.getVersion(Long.valueOf(this.versionId));
        if (this.version == null) {
            this.addErrorMessage(this.getI18nText("bamboo.error.invalid.version", String.valueOf(this.versionId)));
            return "input";
        }
        this.setupDateFormat();
        Project projectObject = this.version.getProject();
        this.openIssueCount = this.getUnresolvedIssues(this.version.getProjectId(), this.versionId);
        this.versions = this.versionManager.getVersionsUnreleased(this.version.getProjectId(), true);
        this.versions.remove(this.version);
        ApplicationLink applicationLink = this.bambooApplicationLinkManager.getApplicationLink(projectObject.getKey());
        boolean bl = this.bambooLinked = applicationLink != null && this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, projectObject, this.getLoggedInUser());
        if (this.bambooLinked) {
            this.applicationLinkName = applicationLink.getName();
            ApplicationLinkRequestFactory authenticatedRequestFactory = applicationLink.createAuthenticatedRequestFactory();
            if (authenticatedRequestFactory == null) {
                this.addErrorMessage(this.getI18nText("bamboo.error.applinks.configuration"));
            } else {
                try {
                    RestResult<Map<BambooProject, List<BambooPlan>>> result = this.bambooRestService.getPlanList(applicationLink, false);
                    this.plansByProject = result.getResult();
                    if (this.plansByProject == null || !result.getErrors().isEmpty()) {
                        this.addErrorMessage(this.getI18nText("bamboo.error.connectivity.continue.jira.release", applicationLink.getName()));
                    }
                }
                catch (CredentialsRequiredException e) {
                    this.log.debug((Object)e.getMessage(), (Throwable)e);
                    ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getOSGiComponentInstanceOfType(ApplicationProperties.class);
                    String baseLinkUrl = this.getBaseUrl(projectObject, this.version);
                    String jiraBaseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
                    this.credentialsUrl = e.getAuthorisationURI(URI.create(jiraBaseUrl + baseLinkUrl));
                    return "input";
                }
            }
        }
        if ((previousConfiguration = this.bambooReleaseService.getConfigData(projectObject.getKey(), this.versionId)) != null) {
            this.useSettingsAsDefaults(previousConfiguration);
        } else {
            this.useSettingsAsDefaults(this.bambooReleaseService.getDefaultSettings(projectObject.getKey()));
        }
        if (StringUtils.isBlank((String)this.buildType)) {
            this.buildType = "new-build";
        }
        return "input";
    }

    private void setupDateFormat() {
        this.dateFormat = DateTimeFormatUtils.getDateFormat();
        if (this.version.getReleaseDate() != null) {
            DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter().withStyle(DateTimeStyle.DATE_PICKER).withZone(TimeZone.getDefault());
            this.formattedReleaseDate = dateTimeFormatter.format(this.version.getReleaseDate());
        } else {
            this.formattedReleaseDate = "";
        }
    }

    private void useSettingsAsDefaults(@Nonnull Map<String, String> settings) {
        this.buildType = settings.get("buildType");
        this.selectedPlanKey = settings.get("plan");
        this.unresolved = settings.get("openIssuesAction");
        this.moveUnfixedIssuesTo = NumberUtils.createLong((String)settings.get("openIssuesMoveVersion"));
        this.selectedStages = settings.get("stage");
        Map<String, String> variables = this.bambooReleaseService.getBambooVariablesFromMap(settings, "");
        if (!variables.isEmpty()) {
            JSONObject variablesJsonObject = new JSONObject();
            try {
                variablesJsonObject.put("variables", variables);
                this.variablesJson = variablesJsonObject.toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    protected String doExecute() {
        this.version = this.versionManager.getVersion(Long.valueOf(this.versionId));
        Project projectObject = this.version.getProject();
        HashMap<String, String> settings = new HashMap<String, String>();
        ApplicationUser user = this.getLoggedInUser();
        settings.put("user", user.getName());
        settings.put("openIssuesAction", this.unresolved);
        settings.put(RELEASE_DATE_FIELD, this.dateFieldFormat.formatDatePicker(this.releaseDate));
        if ("move".equals(this.unresolved)) {
            settings.put("openIssuesMoveVersion", this.moveUnfixedIssuesTo.toString());
        }
        if (StringUtils.isBlank((String)this.buildType)) {
            this.buildType = "no-build";
        }
        settings.put("buildType", this.buildType);
        boolean existingBuild = "existing-build".equals(this.buildType);
        boolean newBuild = "new-build".equals(this.buildType);
        if (newBuild || existingBuild) {
            String errorMessage;
            ApplicationLink applicationLink;
            Map<String, String> variables;
            PlanKey planKey = PlanKeys.getPlanKey(this.selectedPlanKey);
            settings.put("plan", planKey.getKey());
            if (StringUtils.isNotBlank((String)this.selectedStages)) {
                settings.put("stage", this.selectedStages);
            }
            if (!(variables = ConfigureBambooRelease.filterVariableParams(ActionContext.getParameters())).isEmpty()) {
                settings.putAll(variables);
            }
            if ((applicationLink = this.bambooApplicationLinkManager.getApplicationLink(projectObject.getKey())) != null && StringUtils.isNotBlank((String)(errorMessage = this.triggerReleaseBuild(newBuild, applicationLink, settings)))) {
                this.addErrorMessage(errorMessage);
            }
        } else {
            this.bambooReleaseService.releaseWithNoBuild(this.version, settings);
        }
        if (this.hasAnyErrors()) {
            return this.doInput();
        }
        return this.returnCompleteWithInlineRedirect(this.getRedirectUrlOnSuccess());
    }

    @VisibleForTesting
    String triggerReleaseBuild(boolean newBuild, ApplicationLink applicationLink, Map<String, String> settings) {
        try {
            PlanExecutionResult result;
            if (newBuild) {
                result = this.bambooReleaseService.triggerPlanForRelease(applicationLink, this.version, settings);
            } else {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey(this.buildResult);
                result = this.bambooReleaseService.triggerExistingBuildForRelease(applicationLink, this.version, planResultKey, settings);
            }
            if (!result.getErrors().isEmpty()) {
                return this.getI18nText("bamboo.error.connectivity.continue.jira.release", applicationLink.getName());
            }
            return null;
        }
        catch (CredentialsRequiredException e) {
            this.log.error((Object)e.getMessage());
            return this.getI18nText("bambo.error.user.not.authorised", e.getAuthorisationURI().toString());
        }
        catch (Exception e) {
            this.log.error((Object)("Bamboo failed to trigger the release build for version " + (this.version != null ? this.version.getName() : "")), (Throwable)e);
            return this.getI18nText("jira.error.not.recoverable", applicationLink.getName());
        }
    }

    protected void doValidation() {
        this.version = this.versionManager.getVersion(Long.valueOf(this.versionId));
        if (this.version == null) {
            this.addErrorMessage(this.getI18nText("bamboo.error.invalid.version", String.valueOf(this.versionId)));
        } else {
            Project project;
            if ("new-build".equals(this.buildType)) {
                Project projectObject = this.version.getProject();
                if (projectObject == null) {
                    this.addErrorMessage(this.getI18nText("bamboo.error.version.without.project", this.version.getName()));
                }
                if (StringUtils.isBlank((String)this.selectedPlanKey)) {
                    this.addError("selectedPlanKey", this.getI18nText("bamboo.error.invalid.plan"));
                }
            }
            Project project2 = project = this.version != null ? this.version.getProject() : null;
            if (project != null && !this.bambooReleaseService.hasPermissionToRelease(this.getLoggedInUser(), project)) {
                this.addErrorMessage(this.getI18nText("admin.errors.version.no.permission"));
            }
            this.validateReleaseDate();
        }
        if (this.hasAnyErrors()) {
            this.doInput();
        }
    }

    @VisibleForTesting
    String getI18nText(String key, String param1) {
        return this.getI18nHelper().getText(key, param1);
    }

    @VisibleForTesting
    String getI18nText(String key) {
        return this.getI18nHelper().getText(key);
    }

    private void validateReleaseDate() {
        if (this.userReleaseDate == null) {
            this.releaseDate = this.version.getReleaseDate();
        } else if (StringUtils.isBlank((String)this.userReleaseDate)) {
            this.releaseDate = null;
        } else {
            try {
                Date enteredReleaseDate = this.dateFieldFormat.parseDatePicker(this.userReleaseDate);
                this.validateReleaseDate(enteredReleaseDate);
            }
            catch (IllegalArgumentException exc) {
                this.addError(RELEASE_DATE_FIELD, this.getI18nText(INCORRECT_DATE_FORMAT, this.dateFieldFormat.getFormatHint()));
            }
        }
    }

    private void validateReleaseDate(Date enteredReleaseDate) {
        VersionBuilder versionBuilder = this.versionService.newVersionBuilder(this.version).releaseDate(enteredReleaseDate);
        VersionService.VersionBuilderValidationResult result = this.versionService.validateUpdate(this.getLoggedInUser(), versionBuilder);
        if (result.isValid()) {
            this.releaseDate = enteredReleaseDate;
        } else {
            this.addErrorCollection(result.getErrorCollection());
        }
    }

    private int getUnresolvedIssues(long projectId, long versionId) {
        Either<String, Integer> result = this.projectVersionService.getUnresolvedIssueCount(projectId, versionId);
        if (result.isRight()) {
            return (Integer)result.right().get();
        }
        this.addErrorMessage((String)result.left().get());
        return 0;
    }

    private String getBaseUrl(Project project, Version version) {
        return String.format("/browse/%s/fixforversion/%s", project.getKey(), version.getId());
    }

    @VisibleForTesting
    static Map<String, String> filterVariableParams(Map<?, ?> parameters) {
        return parameters.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith("variable_")).filter(entry -> entry.getValue() instanceof String[]).filter(entry -> {
            String[] values = (String[])entry.getValue();
            return values.length > 0 && StringUtils.isNotEmpty((String)values[0]);
        }).collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> ((String[])entry.getValue())[0]));
    }

    @ActionViewData
    public Version getVersion() {
        return this.version;
    }

    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }

    @ActionViewData
    public long getVersionId() {
        return this.versionId;
    }

    @ActionViewData
    public String getUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(String unresolved) {
        this.unresolved = unresolved;
    }

    @ActionViewData
    public Long getMoveUnfixedIssuesTo() {
        return this.moveUnfixedIssuesTo;
    }

    public void setMoveUnfixedIssuesTo(@Nullable Long moveUnfixedIssuesTo) {
        this.moveUnfixedIssuesTo = moveUnfixedIssuesTo;
    }

    @ActionViewData
    public String getRedirectUrlOnSuccess() {
        return this.redirectUrlOnSuccess;
    }

    public void setRedirectUrlOnSuccess(String redirectUrlOnSuccess) {
        this.redirectUrlOnSuccess = redirectUrlOnSuccess;
    }

    @ActionViewData
    public String getBuildType() {
        return this.buildType;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    @ActionViewData
    public Map<BambooProject, List<BambooPlan>> getPlansByProject() {
        return this.plansByProject;
    }

    @ActionViewData
    public Collection<Version> getVersions() {
        return this.versions;
    }

    @ActionViewData
    public URI getCredentialsUrl() {
        return this.credentialsUrl;
    }

    @ActionViewData
    public int getOpenIssueCount() {
        return this.openIssueCount;
    }

    public void setSelectedPlanKey(String selectedPlanKey) {
        this.selectedPlanKey = selectedPlanKey;
    }

    @ActionViewData
    public String getSelectedPlanKey() {
        return this.selectedPlanKey;
    }

    @ActionViewData
    public String getVariablesJson() {
        return this.variablesJson;
    }

    @ActionViewData
    public String getSelectedStages() {
        return this.selectedStages;
    }

    public void setSelectedStages(String selectedStages) {
        this.selectedStages = selectedStages;
    }

    public void setBuildResult(String buildResult) {
        this.buildResult = buildResult;
    }

    @ActionViewData
    public boolean isBambooLinked() {
        return this.bambooLinked;
    }

    @ActionViewData
    public String getUserReleaseDate() {
        return this.userReleaseDate;
    }

    public void setUserReleaseDate(String userReleaseDate) {
        this.userReleaseDate = userReleaseDate;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @ActionViewData
    public String getCurrentReleaseDate() {
        return this.currentReleaseDate;
    }

    public void setCurrentReleaseDate(String currentReleaseDate) {
        this.currentReleaseDate = currentReleaseDate;
    }

    @ActionViewData
    public String getFormattedReleaseDate() {
        return this.formattedReleaseDate;
    }

    @ActionViewData
    public String getApplicationLinkName() {
        return this.applicationLinkName;
    }
}

