/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.panel;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.plugin.ext.bamboo.panel.BambooPanelHelper;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.ext.bamboo.view.BambooVersionTabPanel;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.conditions.ProjectDevToolsIntegrationFeatureCondition;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;

@Scanned
public class BuildsForVersionTabPanel
extends BambooVersionTabPanel {
    @VisibleForTesting
    static final String MODULE_KEY = "bamboo-version-tabpanel";
    @VisibleForTesting
    static final String FEEDBACK_BANNER_DARK_FEATURE_FLAG = "jira.plugin.projects.version.tab.feedback.banner";
    private final FeatureManager featureManager;

    public BuildsForVersionTabPanel(BambooPanelHelper bambooPanelHelper, BambooReleaseService bambooReleaseService, @ComponentImport FeatureManager featureManager, FieldVisibilityManager fieldVisibilityManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition, SearchProvider searchProvider) {
        super(fieldVisibilityManager, authenticationContext, permissionManager, searchProvider, projectDevToolsIntegrationFeatureCondition, bambooPanelHelper, bambooReleaseService, MODULE_KEY);
        this.featureManager = (FeatureManager)Preconditions.checkNotNull((Object)featureManager);
    }

    @Override
    public boolean showPanel(BrowseVersionContext context) {
        return super.showPanel(context) && this.bambooPanelHelper.isBambooAppLinked();
    }

    @Override
    protected boolean showFusionFeedbackBanner() {
        return this.featureManager.isEnabled(FEEDBACK_BANNER_DARK_FEATURE_FLAG);
    }

    @Override
    protected void addVelocityParams(@Nonnull BrowseVersionContext context, @Nonnull Map<String, Object> velocityParams) {
        Version version = context.getVersion();
        this.resetReleaseStateIfVersionWasUnreleased(version);
        if (version.isReleased() && version.getReleaseDate() != null) {
            velocityParams.put("extraDescriptionKey", "released.");
        }
    }

    @Override
    protected void prepareVelocityContext(Map<String, Object> velocityParams, String baseLinkUrl, String queryString, Project project) {
        this.bambooPanelHelper.prepareVelocityContext(velocityParams, MODULE_KEY, baseLinkUrl, queryString, BambooPanelHelper.SUB_TABS, project);
    }
}

