/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.panel;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.panel.BambooPanelHelper;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.conditions.ProjectDevToolsIntegrationFeatureCondition;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

@Scanned
public class BuildsForProjectTabPanel
extends AbstractProjectTabPanel {
    @VisibleForTesting
    static final String CONTEXT_KEY_CONTEXT_TYPE = "contextType";
    @VisibleForTesting
    static final String CONTEXT_KEY_USER = "user";
    @VisibleForTesting
    static final String MODEL_KEY_FIELD_VISIBILITY = "fieldVisibility";
    @VisibleForTesting
    static final String MODEL_KEY_PORTLET = "portlet";
    @VisibleForTesting
    static final String PROJECT_CONTEXT_TYPE = "project";
    @VisibleForTesting
    static final String VIEW_RESOURCE = "view";
    private static final String BAMBOO_PLUGIN_MODULE_KEY = "bamboo-project-tabpanel";
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooPanelHelper bambooPanelHelper;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final PermissionManager permissionManager;
    private final ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition;

    public BuildsForProjectTabPanel(@ComponentImport FieldVisibilityManager fieldVisibilityManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager, BambooApplicationLinkManager bambooApplicationLinkManager, BambooPanelHelper bambooPanelHelper, ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition) {
        super(jiraAuthenticationContext);
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooPanelHelper = (BambooPanelHelper)Preconditions.checkNotNull((Object)bambooPanelHelper);
        this.fieldVisibilityManager = (FieldVisibilityManager)Preconditions.checkNotNull((Object)fieldVisibilityManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectDevToolsIntegrationFeatureCondition = (ProjectDevToolsIntegrationFeatureCondition)Preconditions.checkNotNull((Object)projectDevToolsIntegrationFeatureCondition);
    }

    public String getHtml(BrowseContext context) {
        Project project = context.getProject();
        HashMap velocityParams = Maps.newHashMap();
        velocityParams.put(MODEL_KEY_FIELD_VISIBILITY, this.fieldVisibilityManager);
        velocityParams.put(MODEL_KEY_PORTLET, this);
        String baseLinkUrl = "/browse/" + project.getKey() + "?selectedTab=" + "com.atlassian.jira.plugin.ext.bamboo" + ":" + BAMBOO_PLUGIN_MODULE_KEY;
        String queryString = "projectKey=" + project.getKey();
        this.bambooPanelHelper.prepareVelocityContext(velocityParams, BAMBOO_PLUGIN_MODULE_KEY, baseLinkUrl, queryString, BambooPanelHelper.SUB_TABS, project);
        return this.descriptor.getHtml(VIEW_RESOURCE, (Map)velocityParams);
    }

    public boolean showPanel(BrowseContext context) {
        return this.bambooApplicationLinkManager.hasApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED) && this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, context.getProject(), context.getUser()) && this.projectDevToolsIntegrationFeatureCondition.shouldDisplay(this.getBrowseContextMap(context));
    }

    private Map<String, Object> getBrowseContextMap(BrowseContext context) {
        return ImmutableMap.of((Object)CONTEXT_KEY_CONTEXT_TYPE, (Object)PROJECT_CONTEXT_TYPE, (Object)PROJECT_CONTEXT_TYPE, (Object)context.getProject(), (Object)CONTEXT_KEY_USER, (Object)context.getUser());
    }
}

