/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.panel;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.service.BambooReleaseService;
import com.atlassian.jira.plugin.ext.bamboo.service.ReleaseErrorReportingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import webwork.action.ActionContext;

@Component
public class BambooPanelHelper {
    public static final String BAMBOO_PLUGIN_KEY = "com.atlassian.jira.plugin.ext.bamboo";
    public static final String SELECTED_SUB_TAB_KEY = "selectedSubTab";
    public static final String SUB_TAB_PLAN_STATUS = "planStatus";
    public static final String SUB_TAB_BUILD_BY_PLAN = "buildByPlan";
    public static final String SUB_TAB_BUILD_BY_DATE = "buildByDate";
    public static final List<String> SUB_TABS = ImmutableList.of((Object)"buildByDate", (Object)"planStatus");
    public static final List<String> ALL_SUB_TABS = ImmutableList.of((Object)"buildByDate", (Object)"planStatus", (Object)"buildByPlan");
    @VisibleForTesting
    static final String BUILD_RESULT_KEY = "buildResultKey";
    @VisibleForTesting
    static final String BUILD_TRIGGERED_KEY = "buildTriggered";
    @VisibleForTesting
    static final String COMPLETED_STATE_KEY = "completedState";
    @VisibleForTesting
    static final String DAYS_REMAINING_KEY = "daysRemaining";
    @VisibleForTesting
    static final String HAS_APPLINKS_KEY = "hasApplinks";
    @VisibleForTesting
    static final String IS_PROJECT_ADMIN_KEY = "isProjectAdmin";
    @VisibleForTesting
    static final String OVERDUE_KEY = "overdue";
    @VisibleForTesting
    static final String RELEASE_ERRORS_KEY = "releaseErrors";
    private static final Pattern UNSAFE_CHARACTERS_REGEX = Pattern.compile("[\"'<>\\\\]");
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final BambooReleaseService bambooReleaseService;
    private final ReleaseErrorReportingService releaseErrorReportingService;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;

    @Autowired
    public BambooPanelHelper(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport GlobalPermissionManager globalPermissionManager, BambooApplicationLinkManager bambooApplicationLinkManager, BambooReleaseService bambooReleaseService, ReleaseErrorReportingService releaseErrorReportingService) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.globalPermissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)globalPermissionManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.bambooReleaseService = (BambooReleaseService)Preconditions.checkNotNull((Object)bambooReleaseService);
        this.releaseErrorReportingService = (ReleaseErrorReportingService)Preconditions.checkNotNull((Object)releaseErrorReportingService);
    }

    public void prepareVelocityContext(Map<String, Object> velocityParams, String bambooPluginModuleKey, String baseLinkUrl, String queryString, List subTabs, Project project) {
        String selectedSubTab;
        if (subTabs != null && !subTabs.isEmpty()) {
            velocityParams.put("availableTabs", subTabs);
            selectedSubTab = this.retrieveFromRequestOrSession(SELECTED_SUB_TAB_KEY, SUB_TAB_BUILD_BY_DATE);
            if (!ALL_SUB_TABS.contains(selectedSubTab)) {
                selectedSubTab = SUB_TAB_BUILD_BY_DATE;
            }
        } else {
            selectedSubTab = SUB_TAB_BUILD_BY_DATE;
        }
        velocityParams.put(SELECTED_SUB_TAB_KEY, selectedSubTab);
        if (SUB_TAB_BUILD_BY_DATE.equals(selectedSubTab)) {
            velocityParams.put("showRss", Boolean.TRUE);
        }
        this.prepareVelocityContext(velocityParams, bambooPluginModuleKey, baseLinkUrl, queryString, project);
    }

    public void prepareVelocityContext(Map<String, Object> velocityParams, String bambooPluginModuleKey, String baseLinkUrl, String queryString, Project project) {
        ApplicationLink applicationLink = this.bambooApplicationLinkManager.getApplicationLink(project.getKey());
        velocityParams.put("moduleKey", bambooPluginModuleKey);
        velocityParams.put("querySection", queryString);
        velocityParams.put("baseLinkUrl", baseLinkUrl);
        velocityParams.put("baseResourceUrl", "/download/resources/com.atlassian.jira.plugin.ext.bamboo:" + bambooPluginModuleKey);
        if (applicationLink != null) {
            velocityParams.put("baseBambooUrl", applicationLink.getDisplayUrl().toASCIIString());
            velocityParams.put("baseBambooRestUrl", applicationLink.getRpcUrl() + "/rest/api/latest/");
        }
        velocityParams.put("baseRestUrl", "/rest/bamboo/1.0/");
        velocityParams.put("baseBambooRestProxyUrl", "/rest/bamboo/1.0/proxy/");
        this.sanitiseParams(velocityParams);
        if (applicationLink != null) {
            velocityParams.put("bambooServerName", applicationLink.getName());
        }
        velocityParams.put("isSystemAdmin", this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.jiraAuthenticationContext.getLoggedInUser()));
    }

    public Map<String, Object> getReleaseButtonParams(ApplicationUser user, Version version, Project project) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put(IS_PROJECT_ADMIN_KEY, this.isUserAuthorisedToReleaseProject(user, project));
        velocityParams.put(HAS_APPLINKS_KEY, this.isBambooAppLinked() && this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, project, user));
        this.addBuildParams(version, velocityParams, project.getKey());
        this.addReleaseErrors(version, velocityParams, project.getKey());
        this.addAnalyticsParams(version, velocityParams);
        return velocityParams;
    }

    private boolean isUserAuthorisedToReleaseProject(ApplicationUser user, Project project) {
        return this.bambooReleaseService.hasPermissionToRelease(user, project);
    }

    public boolean isBambooAppLinked() {
        return this.bambooApplicationLinkManager.hasApplicationLinks(BambooApplicationLinkManager.Filter.UNFILTERED);
    }

    private void addAnalyticsParams(@Nonnull Version version, @Nonnull Map<String, Object> velocityParams) {
        velocityParams.put(DAYS_REMAINING_KEY, this.getDaysRemaining(version));
        velocityParams.put(OVERDUE_KEY, this.isOverdue(version));
    }

    private void addBuildParams(Version version, Map<String, Object> velocityParams, String projectKey) {
        Map<String, String> buildParams = this.bambooReleaseService.getBuildData(projectKey, version.getId());
        if (buildParams != null) {
            String completedState;
            velocityParams.put(BUILD_TRIGGERED_KEY, true);
            String planResultKey = buildParams.get("result");
            if (StringUtils.isNotBlank((String)planResultKey)) {
                velocityParams.put(BUILD_RESULT_KEY, planResultKey);
            }
            if (StringUtils.isNotBlank((String)(completedState = buildParams.get("state")))) {
                velocityParams.put(COMPLETED_STATE_KEY, completedState);
            }
        }
    }

    private void addReleaseErrors(Version version, Map<String, Object> velocityParams, String projectKey) {
        List<String> releaseErrors = this.releaseErrorReportingService.getErrors(projectKey, version.getId());
        if (!releaseErrors.isEmpty()) {
            velocityParams.put(RELEASE_ERRORS_KEY, releaseErrors);
        }
    }

    private void sanitiseParams(Map<String, Object> velocityParams) {
        for (Map.Entry<String, Object> entry : velocityParams.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            entry.setValue(this.sanitiseString((String)value));
        }
    }

    private String sanitiseString(String string) {
        return UNSAFE_CHARACTERS_REGEX.matcher(string).replaceAll("");
    }

    private String retrieveFromRequestOrSession(String requestKey, String defaultValue) {
        String value = this.retrieveFromRequestOrSession(requestKey);
        return value != null ? value : defaultValue;
    }

    private String retrieveFromRequestOrSession(String requestKey) {
        String sessionKey = "com.atlassian.jira.plugin.ext.bamboo." + requestKey;
        String paramFromRequest = ParameterUtils.getStringParam((Map)ActionContext.getParameters(), (String)requestKey);
        Map session = ActionContext.getSession();
        if (StringUtils.isNotBlank((String)paramFromRequest)) {
            session.put(sessionKey, paramFromRequest);
            return paramFromRequest;
        }
        return (String)session.get(sessionKey);
    }

    @Nonnull
    private Object getDaysRemaining(@Nonnull Version version) {
        if (version.getReleaseDate() == null) {
            return "null";
        }
        return (version.getReleaseDate().getTime() - System.currentTimeMillis()) / 86400000L;
    }

    private boolean isOverdue(@Nonnull Version version) {
        Date releaseDate = version.getReleaseDate();
        return !version.isReleased() && releaseDate != null && releaseDate.before(new Date());
    }
}

