/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.panel;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.ext.bamboo.applinks.BambooApplicationLinkManager;
import com.atlassian.jira.plugin.ext.bamboo.panel.BambooBuildResultsAction;
import com.atlassian.jira.plugin.ext.bamboo.panel.BambooPanelHelper;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.conditions.ProjectDevToolsIntegrationFeatureCondition;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@Scanned
public class BambooBuildResultsTabPanel
extends AbstractIssueTabPanel {
    public static final String VIEW_BUILD_RESULTS_ACTION_URL = "/ajax/build/viewBuildResultsByJiraKey.action";
    public static final String VIEW_PLANS_ACTION_URL = "/ajax/build/viewPlansByJiraKey.action";
    private final BambooApplicationLinkManager bambooApplicationLinkManager;
    private final BambooPanelHelper bambooPanelHelper;
    private final PermissionManager permissionManager;
    private final ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition;

    public BambooBuildResultsTabPanel(@ComponentImport PermissionManager permissionManager, BambooApplicationLinkManager bambooApplicationLinkManager, BambooPanelHelper bambooPanelHelper, ProjectDevToolsIntegrationFeatureCondition projectDevToolsIntegrationFeatureCondition) {
        this.bambooApplicationLinkManager = (BambooApplicationLinkManager)Preconditions.checkNotNull((Object)bambooApplicationLinkManager);
        this.bambooPanelHelper = (BambooPanelHelper)Preconditions.checkNotNull((Object)bambooPanelHelper);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectDevToolsIntegrationFeatureCondition = (ProjectDevToolsIntegrationFeatureCondition)Preconditions.checkNotNull((Object)projectDevToolsIntegrationFeatureCondition);
    }

    public List<IssueAction> getActions(Issue issue, ApplicationUser remoteUser) {
        return Collections.singletonList(new BambooBuildResultsAction(this.bambooPanelHelper, issue, this.descriptor));
    }

    public boolean showPanel(Issue issue, ApplicationUser remoteUser) {
        HashMap<String, Project> projectContext = new HashMap<String, Project>();
        projectContext.put("project", issue.getProjectObject());
        return this.bambooApplicationLinkManager.hasValidApplicationLinkForIssueBuildPanel(issue.getProjectObject().getKey()) && this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, issue, remoteUser) && this.projectDevToolsIntegrationFeatureCondition.shouldDisplay(projectContext);
    }
}

