/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RestResult<T> {
    private final ImmutableList<String> errors;
    private final T result;
    private final int statusCode;

    public RestResult(@Nullable T result, @Nonnull Collection<String> errors, int statusCode) {
        this.errors = ImmutableList.copyOf(errors);
        this.result = result;
        this.statusCode = statusCode;
    }

    @Nullable
    public T getResult() {
        return this.result;
    }

    @Nonnull
    public ImmutableList<String> getErrors() {
        return this.errors;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nonnull
    public String getErrorMessage(String defaultMessage) {
        if (!this.errors.isEmpty()) {
            return StringUtils.join(this.errors, (String)"<br>");
        }
        return defaultMessage;
    }
}

