/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import com.atlassian.jira.plugin.ext.bamboo.model.BuildState;
import com.atlassian.jira.plugin.ext.bamboo.model.LifeCycleState;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class PlanStatus {
    private final PlanKey planKey;
    private final BuildState latestBuildState;
    private final LifeCycleState latestLifeCycleState;

    public static PlanStatus fromJsonObject(PlanKey planKey, JSONObject jsonObject) throws JSONException {
        String state = jsonObject.getString("state");
        String lifecycle = jsonObject.getString("lifeCycleState");
        BuildState buildState = BuildState.getInstance(state);
        LifeCycleState lifeCycleState = LifeCycleState.getInstance(lifecycle);
        return new PlanStatus(planKey, buildState, lifeCycleState);
    }

    public PlanStatus(PlanKey planKey, BuildState buildState, LifeCycleState lifeCycleState) {
        this.planKey = planKey;
        this.latestBuildState = buildState;
        this.latestLifeCycleState = lifeCycleState;
    }

    @Nonnull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @Nullable
    public BuildState getLatestBuildState() {
        return this.latestBuildState;
    }

    @Nullable
    public LifeCycleState getLatestLifeCycleState() {
        return this.latestLifeCycleState;
    }

    public String toString() {
        return "PlanStatus{planKey=" + this.planKey + ", latestBuildState=" + (Object)((Object)this.latestBuildState) + ", latestLifeCycleState=" + (Object)((Object)this.latestLifeCycleState) + '}';
    }
}

