/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import com.atlassian.jira.plugin.ext.bamboo.model.BuildState;
import com.atlassian.jira.plugin.ext.bamboo.model.LifeCycleState;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class PlanResultStatus {
    private final PlanResultKey planResultKey;
    private final BuildState buildState;
    private final LifeCycleState lifeCycleState;
    private final boolean recoverable;

    public static PlanResultStatus fromJsonObject(PlanResultKey planResultKey, JSONObject jsonObject) throws JSONException {
        String state = jsonObject.getString("state");
        String lifecycle = jsonObject.getString("lifeCycleState");
        BuildState buildState = BuildState.getInstance(state);
        LifeCycleState lifeCycleState = LifeCycleState.getInstance(lifecycle);
        return new PlanResultStatus(planResultKey, buildState, lifeCycleState, true);
    }

    public PlanResultStatus(PlanResultKey planResultKey, BuildState buildState, LifeCycleState lifeCycleState, boolean recoverable) {
        this.planResultKey = planResultKey;
        this.buildState = buildState;
        this.lifeCycleState = lifeCycleState;
        this.recoverable = recoverable;
    }

    @Nonnull
    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    @Nullable
    public BuildState getBuildState() {
        return this.buildState;
    }

    @Nullable
    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public boolean isValid() {
        return this.lifeCycleState != null && this.buildState != null;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public String toString() {
        return "PlanStatus{planResultKey=" + this.planResultKey + ", buildState=" + (Object)((Object)this.buildState) + ", lifeCycleState=" + (Object)((Object)this.lifeCycleState) + ", recoverable=" + this.recoverable + '}';
    }
}

