/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import com.atlassian.jira.plugin.ext.bamboo.model.PlanKey;
import com.atlassian.jira.plugin.ext.bamboo.model.PlanResultKey;
import org.apache.commons.lang.StringUtils;

public final class PlanKeys {
    public static final char SEP = '-';

    private PlanKeys() {
    }

    public static PlanKey getPlanKey(String planKey) {
        String[] parts = StringUtils.split((String)planKey, (char)'-');
        if (parts == null || parts.length > 4 || parts.length < 2) {
            throw new IllegalArgumentException("Could not parse key '" + planKey + "'");
        }
        if (parts.length >= 3) {
            try {
                Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                return new PlanKey(parts[0] + '-' + parts[1] + '-' + parts[2]);
            }
        }
        return new PlanKey(parts[0] + '-' + parts[1]);
    }

    public static PlanResultKey getPlanResultKey(String planResultKey) {
        return PlanKeys.parse(PlanKeys.getPlanKey(planResultKey), planResultKey);
    }

    private static PlanResultKey parse(PlanKey planKey, String key) {
        Integer buildNumber;
        String numberPart;
        String[] parts = StringUtils.split((String)key, (char)'-');
        if (parts.length == 3) {
            numberPart = parts[2];
        } else if (parts.length == 4) {
            numberPart = parts[3];
        } else {
            throw new IllegalArgumentException("Could not parse key '" + key + "'");
        }
        try {
            buildNumber = Integer.parseInt(numberPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse build number part of key '" + key + "'");
        }
        return new PlanResultKey(planKey, buildNumber);
    }
}

