/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public enum LifeCycleState {
    PENDING("Pending"),
    QUEUED("Queued"),
    IN_PROGRESS("InProgress"),
    FINISHED("Finished"),
    NOT_BUILT("NotBuilt");

    public static final EnumSet<LifeCycleState> ACTIVE_STATES;
    public static final EnumSet<LifeCycleState> FINAL_STATES;
    private final String state;
    private static final Map<String, LifeCycleState> LIFE_CYCLE_STATE_MAPPING;

    private LifeCycleState(String state) {
        this.state = state;
    }

    public static LifeCycleState getInstance(String state) {
        LifeCycleState lifeCycleState = LIFE_CYCLE_STATE_MAPPING.get(state);
        Validate.notNull((Object)((Object)lifeCycleState), (String)("There is no LifeCycleState called '" + state + "'"));
        return lifeCycleState;
    }

    public String getValue() {
        return this.state;
    }

    public String toString() {
        return this.state;
    }

    public static boolean isPending(LifeCycleState lifeCycleState) {
        return lifeCycleState == PENDING;
    }

    public static boolean isQueued(LifeCycleState lifeCycleState) {
        return lifeCycleState == QUEUED;
    }

    public static boolean isWaiting(LifeCycleState lifeCycleState) {
        return LifeCycleState.isPending(lifeCycleState) || LifeCycleState.isQueued(lifeCycleState);
    }

    public static boolean isActive(LifeCycleState lifeCycleState) {
        return ACTIVE_STATES.contains((Object)lifeCycleState);
    }

    public static boolean isFinalized(LifeCycleState lifeCycleState) {
        return FINAL_STATES.contains((Object)lifeCycleState);
    }

    public static boolean isInProgress(LifeCycleState lifeCycleState) {
        return lifeCycleState == IN_PROGRESS;
    }

    public static boolean isFinished(LifeCycleState lifeCycleState) {
        return lifeCycleState == FINISHED;
    }

    public static boolean isNotBuilt(LifeCycleState lifeCycleState) {
        return lifeCycleState == NOT_BUILT;
    }

    static {
        ACTIVE_STATES = EnumSet.of(PENDING, QUEUED, IN_PROGRESS);
        FINAL_STATES = EnumSet.of(FINISHED, NOT_BUILT);
        LIFE_CYCLE_STATE_MAPPING = new HashMap<String, LifeCycleState>(){
            {
                for (LifeCycleState lifeCycleState : LifeCycleState.values()) {
                    this.put(lifeCycleState.state, lifeCycleState);
                }
            }
        };
    }
}

