/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.model;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorMessage {
    private final String title;
    private final String description;

    public ErrorMessage(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public JSONObject createJSONOBject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("message", (Object)this.title);
            jsonObject.put("messageBody", (Object)this.description);
            for (Map.Entry<String, String> entry : this.getExtraValues().entrySet()) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not build JSON object", e);
        }
        return jsonObject;
    }

    public Response.ResponseBuilder createJSONEntity(Response.ResponseBuilder builder) {
        JSONObject jsonObject = this.createJSONOBject();
        return builder.entity((Object)jsonObject.toString());
    }

    @Nonnull
    protected Map<String, String> getExtraValues() {
        return Collections.emptyMap();
    }
}

